/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.jaas;

import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.boot.ProxyLoginModule;
import org.apache.karaf.jaas.config.JaasRealm;
import org.eclipse.sisu.EagerSingleton;
import org.osgi.framework.BundleContext;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.security.jaas.ShiroLoginModule;
import org.sonatype.nexus.security.SecurityHelper;
import org.sonatype.nexus.security.SecuritySystem;

@Named
@EagerSingleton
public class ShiroJaasRealm
extends ComponentSupport
implements JaasRealm {
    private final AppConfigurationEntry[] entries;

    @Inject
    public ShiroJaasRealm(BundleContext bundleContext, SecurityHelper securityHelper, SecuritySystem securitySystem) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(BundleContext.class.getName(), bundleContext);
        options.put(SecurityHelper.class.getName(), securityHelper);
        options.put(SecuritySystem.class.getName(), securitySystem);
        options.put("org.apache.karaf.jaas.module", ShiroLoginModule.class.getName());
        options.put("org.apache.karaf.jaas.bundle", Long.toString(bundleContext.getBundle().getBundleId()));
        this.entries = new AppConfigurationEntry[]{new AppConfigurationEntry(ProxyLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, options)};
        bundleContext.registerService(JaasRealm.class, (Object)this, null);
    }

    public String getName() {
        return "shiro";
    }

    public int getRank() {
        return 0;
    }

    public AppConfigurationEntry[] getEntries() {
        return (AppConfigurationEntry[])this.entries.clone();
    }
}

