/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.google.common.collect.Sets;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;
import org.sonatype.nexus.security.config.CRole;

@Named
@Singleton
public class CRoleEntityAdapter
extends IterableEntityAdapter<CRole> {
    private static final String DB_CLASS = new OClassNameBuilder().type("role").build();
    private static final String P_ID = "id";
    private static final String P_NAME = "name";
    private static final String P_DESCRIPTION = "description";
    private static final String P_PRIVILEGES = "privileges";
    private static final String P_ROLES = "roles";
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private final ReadEntityByPropertyAction<CRole> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final UpdateEntityByPropertyAction<CRole> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});

    public CRoleEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_NAME, OType.STRING).setNotNull(true);
        type.createProperty(P_DESCRIPTION, OType.STRING);
        type.createProperty(P_PRIVILEGES, OType.EMBEDDEDSET);
        type.createProperty(P_ROLES, OType.EMBEDDEDSET);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
    }

    protected CRole newEntity() {
        return new CRole();
    }

    protected void readFields(ODocument document, CRole entity) throws Exception {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setName((String)document.field(P_NAME, OType.STRING));
        entity.setDescription((String)document.field(P_DESCRIPTION, OType.STRING));
        entity.setPrivileges((Set)Sets.newHashSet((Iterable)((Iterable)document.field(P_PRIVILEGES, OType.EMBEDDEDSET))));
        entity.setRoles((Set)Sets.newHashSet((Iterable)((Iterable)document.field(P_ROLES, OType.EMBEDDEDSET))));
        entity.setReadOnly(false);
        entity.setVersion(String.valueOf(document.getVersion()));
    }

    protected void writeFields(ODocument document, CRole entity) throws Exception {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_NAME, (Object)entity.getName());
        document.field(P_DESCRIPTION, (Object)entity.getDescription());
        document.field(P_PRIVILEGES, (Object)entity.getPrivileges());
        document.field(P_ROLES, (Object)entity.getRoles());
    }

    @Nullable
    public CRole read(ODatabaseDocumentTx db, String id) {
        return (CRole)this.read.execute(db, new Object[]{id});
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }

    public boolean update(ODatabaseDocumentTx db, CRole entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getId()});
    }
}

