/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;
import org.sonatype.nexus.orient.entity.action.DeleteEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.ReadEntityByPropertyAction;
import org.sonatype.nexus.orient.entity.action.UpdateEntityByPropertyAction;
import org.sonatype.nexus.security.config.CUser;

@Named
@Singleton
public class CUserEntityAdapter
extends IterableEntityAdapter<CUser> {
    private static final String DB_CLASS = new OClassNameBuilder().type("user").build();
    private static final String P_ID = "id";
    private static final String P_FIRST_NAME = "firstName";
    private static final String P_LAST_NAME = "lastName";
    private static final String P_PASSWORD = "password";
    private static final String P_STATUS = "status";
    private static final String P_EMAIL = "email";
    private static final String I_ID = new OIndexNameBuilder().type(DB_CLASS).property("id").build();
    private final ReadEntityByPropertyAction<CUser> read = new ReadEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final DeleteEntityByPropertyAction delete = new DeleteEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});
    private final UpdateEntityByPropertyAction<CUser> update = new UpdateEntityByPropertyAction((EntityAdapter)this, new String[]{"id"});

    public CUserEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_ID, OType.STRING).setNotNull(true);
        type.createProperty(P_FIRST_NAME, OType.STRING);
        type.createProperty(P_LAST_NAME, OType.STRING);
        type.createProperty(P_PASSWORD, OType.STRING).setNotNull(true);
        type.createProperty(P_STATUS, OType.STRING).setNotNull(true);
        type.createProperty(P_EMAIL, OType.STRING).setNotNull(true);
        type.createIndex(I_ID, OClass.INDEX_TYPE.UNIQUE, new String[]{P_ID});
    }

    protected CUser newEntity() {
        return new CUser();
    }

    protected void readFields(ODocument document, CUser entity) throws Exception {
        entity.setId((String)document.field(P_ID, OType.STRING));
        entity.setFirstName((String)document.field(P_FIRST_NAME, OType.STRING));
        entity.setLastName((String)document.field(P_LAST_NAME, OType.STRING));
        entity.setPassword((String)document.field(P_PASSWORD, OType.STRING));
        entity.setStatus((String)document.field(P_STATUS, OType.STRING));
        entity.setEmail((String)document.field(P_EMAIL, OType.STRING));
        entity.setVersion(String.valueOf(document.getVersion()));
    }

    protected void writeFields(ODocument document, CUser entity) throws Exception {
        document.field(P_ID, (Object)entity.getId());
        document.field(P_FIRST_NAME, (Object)entity.getFirstName());
        document.field(P_LAST_NAME, (Object)entity.getLastName());
        document.field(P_STATUS, (Object)entity.getStatus());
        document.field(P_EMAIL, (Object)entity.getEmail());
        document.field(P_PASSWORD, (Object)entity.getPassword());
    }

    @Nullable
    public CUser read(ODatabaseDocumentTx db, String id) {
        return (CUser)this.read.execute(db, new Object[]{id});
    }

    public boolean delete(ODatabaseDocumentTx db, String id) {
        return this.delete.execute(db, new Object[]{id});
    }

    public boolean update(ODatabaseDocumentTx db, CUser entity) {
        return this.update.execute(db, (Entity)entity, new Object[]{entity.getId()});
    }
}

