/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.model.CPrivilegeEntityAdapter;
import org.sonatype.nexus.internal.security.model.CRoleEntityAdapter;
import org.sonatype.nexus.internal.security.model.CUserEntityAdapter;
import org.sonatype.nexus.internal.security.model.CUserRoleMappingEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.security.config.CPrivilege;
import org.sonatype.nexus.security.config.CRole;
import org.sonatype.nexus.security.config.CUser;
import org.sonatype.nexus.security.config.CUserRoleMapping;
import org.sonatype.nexus.security.config.SecurityConfiguration;
import org.sonatype.nexus.security.config.SecurityConfigurationSource;
import org.sonatype.nexus.security.privilege.NoSuchPrivilegeException;
import org.sonatype.nexus.security.role.NoSuchRoleException;
import org.sonatype.nexus.security.user.NoSuchRoleMappingException;
import org.sonatype.nexus.security.user.UserNotFoundException;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientSecurityConfigurationSource
extends StateGuardLifecycleSupport
implements SecurityConfigurationSource {
    private final Provider<DatabaseInstance> databaseInstance;
    private final SecurityConfigurationSource securityDefaults;
    private final CUserEntityAdapter userEntityAdapter;
    private final CRoleEntityAdapter roleEntityAdapter;
    private final CPrivilegeEntityAdapter privilegeEntityAdapter;
    private final CUserRoleMappingEntityAdapter userRoleMappingEntityAdapter;
    private SecurityConfiguration configuration;

    @Inject
    public OrientSecurityConfigurationSource(@Named(value="security") Provider<DatabaseInstance> databaseInstance, @Named(value="static") SecurityConfigurationSource defaults, CUserEntityAdapter userEntityAdapter, CRoleEntityAdapter roleEntityAdapter, CPrivilegeEntityAdapter privilegeEntityAdapter, CUserRoleMappingEntityAdapter userRoleMappingEntityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.securityDefaults = (SecurityConfigurationSource)Preconditions.checkNotNull((Object)defaults);
        this.userEntityAdapter = (CUserEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)userEntityAdapter)));
        this.roleEntityAdapter = (CRoleEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)roleEntityAdapter)));
        this.privilegeEntityAdapter = (CPrivilegeEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)privilegeEntityAdapter)));
        this.userRoleMappingEntityAdapter = (CUserRoleMappingEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)userRoleMappingEntityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (final ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.userEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List users = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getUsers();
                    if (users != null && !users.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default users");
                        for (CUser user : users) {
                            OrientSecurityConfigurationSource.this.userEntityAdapter.addEntity(db, (Entity)user);
                        }
                    }
                }
            });
            this.roleEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List roles = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getRoles();
                    if (roles != null && !roles.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default roles");
                        for (CRole role : roles) {
                            OrientSecurityConfigurationSource.this.roleEntityAdapter.addEntity(db, (Entity)role);
                        }
                    }
                }
            });
            this.privilegeEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List privileges = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getPrivileges();
                    if (privileges != null && !privileges.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default privileges");
                        for (CPrivilege privilege : privileges) {
                            OrientSecurityConfigurationSource.this.privilegeEntityAdapter.addEntity(db, (Entity)privilege);
                        }
                    }
                }
            });
            this.userRoleMappingEntityAdapter.register(db, new Runnable(){

                @Override
                public void run() {
                    List mappings = OrientSecurityConfigurationSource.this.securityDefaults.getConfiguration().getUserRoleMappings();
                    if (mappings != null && !mappings.isEmpty()) {
                        OrientSecurityConfigurationSource.this.log.info("Initializing default user/role mappings");
                        for (CUserRoleMapping mapping : mappings) {
                            OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.addEntity(db, (Entity)mapping);
                        }
                    }
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public SecurityConfiguration getConfiguration() {
        return this.configuration;
    }

    public SecurityConfiguration loadConfiguration() {
        this.configuration = new OrientSecurityConfiguration();
        return this.getConfiguration();
    }

    private class OrientSecurityConfiguration
    implements SecurityConfiguration {
        private OrientSecurityConfiguration() {
        }

        private ConcurrentModificationException concurrentlyModified(String type, String value) {
            throw new ConcurrentModificationException(String.valueOf(type) + " '" + value + "' updated in the meantime");
        }

        public List<CUser> getUsers() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all users");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.userEntityAdapter.browse(db)));
        }

        public CUser getUser(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving user: {}", (Object)id);
            return (CUser)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.userEntityAdapter.read(db, id));
        }

        public void addUser(CUser user, Set<String> roles) {
            Preconditions.checkNotNull((Object)user);
            Preconditions.checkNotNull((Object)user.getId());
            OrientSecurityConfigurationSource.this.log.trace("Adding user: {}", (Object)user.getId());
            OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                OrientSecurityConfigurationSource.this.userEntityAdapter.addEntity(db, (Entity)user);
                this.addUserRoleMapping(this.mapping(user.getId(), roles));
            });
        }

        public void updateUser(CUser user) throws UserNotFoundException {
            Preconditions.checkNotNull((Object)user);
            Preconditions.checkNotNull((Object)user.getId());
            OrientSecurityConfigurationSource.this.log.trace("Updating user: {}", (Object)user.getId());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(UserNotFoundException.class).run(db -> {
                    CUser existing = OrientSecurityConfigurationSource.this.userEntityAdapter.read(db, user.getId());
                    if (existing == null) {
                        throw new UserNotFoundException(user.getId());
                    }
                    OrientSecurityConfigurationSource.this.userEntityAdapter.update(db, user);
                });
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("User", user.getId());
            }
        }

        public void updateUser(CUser user, Set<String> roles) throws UserNotFoundException {
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(UserNotFoundException.class).run(db -> {
                    this.updateUser(user);
                    CUserRoleMapping mapping = OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.read(db, user.getId(), "default");
                    if (mapping == null) {
                        this.addUserRoleMapping(this.mapping(user.getId(), roles));
                    } else {
                        try {
                            mapping.setRoles(roles);
                            this.updateUserRoleMapping(mapping);
                        }
                        catch (NoSuchRoleMappingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("User", user.getId());
            }
        }

        public boolean removeUser(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Removing user: {}", (Object)id);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> {
                    if (OrientSecurityConfigurationSource.this.userEntityAdapter.delete(db, id)) {
                        this.removeUserRoleMapping(id, "default");
                        return true;
                    }
                    return false;
                });
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("User", id);
            }
        }

        public List<CPrivilege> getPrivileges() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all privileges");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.privilegeEntityAdapter.browse(db)));
        }

        public CPrivilege getPrivilege(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving privilege {}", (Object)id);
            return (CPrivilege)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.privilegeEntityAdapter.read(db, id));
        }

        public void addPrivilege(CPrivilege privilege) {
            Preconditions.checkNotNull((Object)privilege);
            Preconditions.checkNotNull((Object)privilege.getId());
            OrientSecurityConfigurationSource.this.log.trace("Adding privilege: {}", (Object)privilege.getId());
            OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                ODocument oDocument = OrientSecurityConfigurationSource.this.privilegeEntityAdapter.addEntity(db, (Entity)privilege);
            });
        }

        public void updatePrivilege(CPrivilege privilege) throws NoSuchPrivilegeException {
            Preconditions.checkNotNull((Object)privilege);
            Preconditions.checkNotNull((Object)privilege.getId());
            OrientSecurityConfigurationSource.this.log.trace("Updating privilege: {}", (Object)privilege.getId());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(NoSuchPrivilegeException.class).run(db -> {
                    CPrivilege existing = OrientSecurityConfigurationSource.this.privilegeEntityAdapter.read(db, privilege.getId());
                    if (existing == null) {
                        throw new NoSuchPrivilegeException(privilege.getId());
                    }
                    OrientSecurityConfigurationSource.this.privilegeEntityAdapter.update(db, privilege);
                });
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("Privilege", privilege.getId());
            }
        }

        public boolean removePrivilege(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Removing privilege: {}", (Object)id);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.privilegeEntityAdapter.delete(db, id));
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("Privilege", id);
            }
        }

        public List<CRole> getRoles() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all roles");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.roleEntityAdapter.browse(db)));
        }

        public CRole getRole(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving role: {}", (Object)id);
            return (CRole)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.roleEntityAdapter.read(db, id));
        }

        public void addRole(CRole role) {
            Preconditions.checkNotNull((Object)role);
            Preconditions.checkNotNull((Object)role.getId());
            OrientSecurityConfigurationSource.this.log.trace("Adding role: {}", (Object)role.getId());
            OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                ODocument oDocument = OrientSecurityConfigurationSource.this.roleEntityAdapter.addEntity(db, (Entity)role);
            });
        }

        public void updateRole(CRole role) throws NoSuchRoleException {
            Preconditions.checkNotNull((Object)role);
            Preconditions.checkNotNull((Object)role.getId());
            OrientSecurityConfigurationSource.this.log.trace("Updating role: {}", (Object)role.getId());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(NoSuchRoleException.class).run(db -> {
                    CRole existing = OrientSecurityConfigurationSource.this.roleEntityAdapter.read(db, role.getId());
                    if (existing == null) {
                        throw new NoSuchRoleException(role.getId());
                    }
                    if (!Objects.equals(role.getVersion(), existing.getVersion())) {
                        throw this.concurrentlyModified("Role", role.getId());
                    }
                    OrientSecurityConfigurationSource.this.roleEntityAdapter.update(db, role);
                });
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("Role", role.getId());
            }
        }

        public boolean removeRole(String id) {
            Preconditions.checkNotNull((Object)id);
            OrientSecurityConfigurationSource.this.log.trace("Removing role: {}", (Object)id);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.roleEntityAdapter.delete(db, id));
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("Role", id);
            }
        }

        private CUserRoleMapping mapping(String userId, Set<String> roles) {
            CUserRoleMapping mapping = new CUserRoleMapping();
            mapping.setUserId(userId);
            mapping.setSource("default");
            mapping.setRoles(roles);
            return mapping;
        }

        public List<CUserRoleMapping> getUserRoleMappings() {
            OrientSecurityConfigurationSource.this.log.trace("Retrieving all user/role mappings");
            return (List)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> ImmutableList.copyOf((Iterable)OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.browse(db)));
        }

        public CUserRoleMapping getUserRoleMapping(String userId, String source) {
            Preconditions.checkNotNull((Object)userId);
            Preconditions.checkNotNull((Object)source);
            OrientSecurityConfigurationSource.this.log.trace("Retrieving user/role mappings of: {}/{}", (Object)userId, (Object)source);
            return (CUserRoleMapping)OrientTransactional.inTx((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.read(db, userId, source));
        }

        public void addUserRoleMapping(CUserRoleMapping mapping) {
            Preconditions.checkNotNull((Object)mapping);
            Preconditions.checkNotNull((Object)mapping.getUserId());
            Preconditions.checkNotNull((Object)mapping.getSource());
            OrientSecurityConfigurationSource.this.log.trace("Adding user/role mappings for: {}/{}", (Object)mapping.getUserId(), (Object)mapping.getSource());
            OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).run(db -> {
                ODocument oDocument = OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.addEntity(db, (Entity)mapping);
            });
        }

        public void updateUserRoleMapping(CUserRoleMapping mapping) throws NoSuchRoleMappingException {
            Preconditions.checkNotNull((Object)mapping);
            Preconditions.checkNotNull((Object)mapping.getUserId());
            Preconditions.checkNotNull((Object)mapping.getSource());
            OrientSecurityConfigurationSource.this.log.trace("Updating user/role mappings for: {}/{}", (Object)mapping.getUserId(), (Object)mapping.getSource());
            try {
                OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).throwing(NoSuchRoleMappingException.class).run(db -> {
                    CUserRoleMapping existing = OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.read(db, mapping.getUserId(), mapping.getSource());
                    if (existing == null) {
                        throw new NoSuchRoleMappingException(mapping.getUserId());
                    }
                    if (!Objects.equals(mapping.getVersion(), existing.getVersion())) {
                        throw this.concurrentlyModified("User-role mapping", mapping.getUserId());
                    }
                    OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.update(db, mapping);
                });
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("User-role mapping", mapping.getUserId());
            }
        }

        public boolean removeUserRoleMapping(String userId, String source) {
            Preconditions.checkNotNull((Object)userId);
            Preconditions.checkNotNull((Object)source);
            OrientSecurityConfigurationSource.this.log.trace("Removing user/role mappings for: {}/{}", (Object)userId, (Object)source);
            try {
                return (Boolean)OrientTransactional.inTxRetry((Provider)OrientSecurityConfigurationSource.this.databaseInstance).call(db -> OrientSecurityConfigurationSource.this.userRoleMappingEntityAdapter.delete(db, userId, source));
            }
            catch (OConcurrentModificationException oConcurrentModificationException) {
                throw this.concurrentlyModified("User-role mapping", userId);
            }
        }
    }
}

