/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.realm;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.entity.Entity;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.internal.security.realm.RealmConfigurationEntityAdapter;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientTransactional;
import org.sonatype.nexus.security.realm.RealmConfiguration;
import org.sonatype.nexus.security.realm.RealmConfigurationStore;

@Named(value="orient")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientRealmConfigurationStore
extends StateGuardLifecycleSupport
implements RealmConfigurationStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final RealmConfigurationEntityAdapter entityAdapter;

    @Inject
    public OrientRealmConfigurationStore(@Named(value="security") Provider<DatabaseInstance> databaseInstance, RealmConfigurationEntityAdapter entityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (RealmConfigurationEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entityAdapter)));
    }

    protected void doStart() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nullable
    @Guarded(by={"STARTED"})
    public RealmConfiguration load() {
        return (RealmConfiguration)OrientTransactional.inTx(this.databaseInstance).call(arg_0 -> ((RealmConfigurationEntityAdapter)this.entityAdapter).get(arg_0));
    }

    @Guarded(by={"STARTED"})
    public void save(RealmConfiguration configuration) {
        OrientTransactional.inTxRetry(this.databaseInstance).run(db -> {
            boolean bl = this.entityAdapter.set(db, (Entity)configuration);
        });
    }
}

