/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.security.realm;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.entity.EntityEvent;
import org.sonatype.nexus.common.entity.EntityMetadata;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.entity.AttachedEntityMetadata;
import org.sonatype.nexus.orient.entity.EntityAdapter;
import org.sonatype.nexus.orient.entity.SingletonEntityAdapter;
import org.sonatype.nexus.security.realm.RealmConfiguration;
import org.sonatype.nexus.security.realm.RealmConfigurationCreatedEvent;
import org.sonatype.nexus.security.realm.RealmConfigurationDeletedEvent;
import org.sonatype.nexus.security.realm.RealmConfigurationUpdatedEvent;

@Named
@Singleton
public class RealmConfigurationEntityAdapter
extends SingletonEntityAdapter<RealmConfiguration> {
    private static final String DB_CLASS = new OClassNameBuilder().type("realm").build();
    private static final String P_REALM_NAMES = "realm_names";

    public RealmConfigurationEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_REALM_NAMES, OType.EMBEDDEDLIST);
    }

    protected RealmConfiguration newEntity() {
        return new RealmConfiguration();
    }

    protected void readFields(ODocument document, RealmConfiguration entity) {
        List realms = (List)document.field(P_REALM_NAMES, OType.EMBEDDEDLIST);
        entity.setRealmNames(realms);
    }

    protected void writeFields(ODocument document, RealmConfiguration entity) {
        document.field(P_REALM_NAMES, (Object)entity.getRealmNames());
    }

    public EntityEvent newEvent(ODocument document, EntityAdapter.EventKind eventKind) {
        AttachedEntityMetadata metadata = new AttachedEntityMetadata((EntityAdapter)this, document);
        this.log.debug("Emitted {} event with metadata {}", (Object)eventKind, (Object)metadata);
        switch (eventKind) {
            case CREATE: {
                return new RealmConfigurationCreatedEvent((EntityMetadata)metadata);
            }
            case UPDATE: {
                return new RealmConfigurationUpdatedEvent((EntityMetadata)metadata);
            }
            case DELETE: {
                return new RealmConfigurationDeletedEvent((EntityMetadata)metadata);
            }
        }
        return null;
    }
}

