/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.template;

import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogChute;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;

class Slf4jLogChute
implements LogChute {
    private final Logger logger = Loggers.getLogger(VelocityEngine.class);
    private final boolean redirectVelocityInfoToDebug;

    public Slf4jLogChute() {
        this.redirectVelocityInfoToDebug = true;
    }

    public void init(RuntimeServices srv) throws Exception {
    }

    public boolean isLevelEnabled(int level) {
        switch (level) {
            case -1: {
                return this.logger.isTraceEnabled();
            }
            case 0: {
                return this.logger.isDebugEnabled();
            }
            case 1: {
                return this.redirectVelocityInfoToDebug ? this.logger.isDebugEnabled() : this.logger.isInfoEnabled();
            }
            case 2: {
                return this.logger.isWarnEnabled();
            }
            case 3: {
                return this.logger.isErrorEnabled();
            }
        }
        return level > 1;
    }

    public void log(int level, String msg) {
        switch (level) {
            case -1: {
                this.logger.trace(msg);
                break;
            }
            case 0: {
                this.logger.debug(msg);
                break;
            }
            case 1: {
                if (this.redirectVelocityInfoToDebug) {
                    this.logger.debug(msg);
                    break;
                }
                this.logger.info(msg);
                break;
            }
            case 2: {
                this.logger.warn(msg);
                break;
            }
            case 3: {
                this.logger.error(msg);
                break;
            }
            default: {
                this.logger.info(msg);
            }
        }
    }

    public void log(int level, String msg, Throwable t) {
        switch (level) {
            case -1: {
                this.logger.trace(msg, t);
                break;
            }
            case 0: {
                this.logger.debug(msg, t);
                break;
            }
            case 1: {
                if (this.redirectVelocityInfoToDebug) {
                    this.logger.debug(msg, t);
                    break;
                }
                this.logger.info(msg, t);
                break;
            }
            case 2: {
                this.logger.warn(msg, t);
                break;
            }
            case 3: {
                this.logger.error(msg, t);
                break;
            }
            default: {
                this.logger.info(msg, t);
            }
        }
    }
}

