/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.template;

import com.google.common.base.Throwables;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.velocity.app.VelocityEngine;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.internal.template.Slf4jLogChute;

@Named
@Singleton
public class VelocityEngineProvider
extends ComponentSupport
implements Provider<VelocityEngine> {
    private final VelocityEngine engine = this.create();

    @Inject
    public VelocityEngineProvider() {
    }

    public VelocityEngine get() {
        return this.engine;
    }

    private VelocityEngine create() {
        VelocityEngine engine = new VelocityEngine();
        engine.setProperty("runtime.log.logsystem", (Object)new Slf4jLogChute());
        engine.setProperty("velocimacro.library", (Object)"");
        engine.setProperty("resource.loader", (Object)"class");
        engine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        engine.setProperty("runtime.references.strict", (Object)"true");
        engine.setProperty("resource.loader", (Object)"class");
        engine.setProperty("class.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        engine.setProperty("class.resource.loader.cache", (Object)"true");
        engine.setProperty("class.resource.loader.modificationCheckInterval", (Object)"0");
        engine.setProperty("runtime.references.strict", (Object)"false");
        engine.setProperty("velocimacro.permissions.allow.inline.local.scope", (Object)"true");
        this.log.debug("Initializing: {}", (Object)engine);
        try {
            engine.init();
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
        return engine;
    }
}

