/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.web;

import com.google.common.base.Preconditions;
import com.google.inject.OutOfScopeException;
import com.google.inject.ProvisionException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import org.sonatype.nexus.security.ClientInfo;
import org.sonatype.nexus.security.ClientInfoProvider;
import org.sonatype.nexus.security.UserIdHelper;

@Named
@Singleton
public class ClientInfoProviderImpl
implements ClientInfoProvider {
    private final Provider<HttpServletRequest> httpRequestProvider;

    @Inject
    public ClientInfoProviderImpl(Provider<HttpServletRequest> httpRequestProvider) {
        this.httpRequestProvider = (Provider)Preconditions.checkNotNull(httpRequestProvider);
    }

    @Nullable
    public ClientInfo getCurrentThreadClientInfo() {
        try {
            HttpServletRequest request = (HttpServletRequest)this.httpRequestProvider.get();
            return new ClientInfo(UserIdHelper.get(), request.getRemoteAddr(), request.getHeader("User-Agent"));
        }
        catch (OutOfScopeException | ProvisionException throwable) {
            return null;
        }
    }
}

