/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.web;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.sisu.Hidden;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Hidden
@Singleton
public class HeaderPatternFilter
extends ComponentSupport
implements Filter {
    private static final String PATTERNS_PROPERTIES_FILE = "http-headers-patterns.properties";
    private ImmutableMap<String, Pattern> validHeaderPatterns;

    public void init(FilterConfig filterConfig) throws ServletException {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Iterator<String> iterator = null;
            try (InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream(PATTERNS_PROPERTIES_FILE);){
                properties.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            this.log.error("IOException loading {} as a resource stream", (Object)PATTERNS_PROPERTIES_FILE, (Object)ioe);
        }
        for (String key : properties.stringPropertyNames()) {
            String val = properties.getProperty(key);
            try {
                builder.put((Object)key, (Object)Pattern.compile(val));
            }
            catch (PatternSyntaxException pse) {
                this.log.error("unable to compile the pattern for the header '{}', failed pattern is '{}', skipping", new Object[]{key, val, pse});
            }
        }
        this.validHeaderPatterns = builder.build();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            for (Map.Entry entry : this.validHeaderPatterns.entrySet()) {
                if (!HeaderPatternFilter.checkForBadHeader(httpRequest.getHeaders((String)entry.getKey()), (Pattern)entry.getValue())) continue;
                this.log.warn("rejecting request from {} due to invalid header '{}: {}'", new Object[]{request.getRemoteHost(), entry.getKey(), Joiner.on((String)",").join(Collections.list(httpRequest.getHeaders((String)entry.getKey())))});
                httpResponse.setStatus(400);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }

    private static boolean checkForBadHeader(Enumeration<String> headers, Pattern expression) {
        while (headers != null && headers.hasMoreElements()) {
            String header = headers.nextElement();
            if (Strings.isNullOrEmpty((String)header) || expression.matcher(header).matches()) continue;
            return true;
        }
        return false;
    }
}

