/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.webresources;

import com.google.common.base.Throwables;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class DevModeResources
extends ComponentSupport {
    private static final String ENV_VAR = "NEXUS_RESOURCE_DIRS";
    private static final String SYS_PROP = "nexus.resource.dirs";
    @Nullable
    private final List<File> resourceLocations = this.initializeResourceLocations();

    @Nullable
    private String detectSearchPath() {
        String envVar = System.getenv(ENV_VAR);
        String sysProp = System.getProperty(SYS_PROP);
        if (envVar != null && sysProp != null) {
            this.log.warn("Both environment-variable: {} and system-property: {} are set; environment-variable takes precedence", (Object)ENV_VAR, (Object)SYS_PROP);
        }
        if (envVar != null) {
            this.log.info("Search-path configured from environment-variable: {}", (Object)ENV_VAR);
            return envVar;
        }
        if (sysProp != null) {
            this.log.info("Search-path configured from system-property: {}", (Object)SYS_PROP);
            return sysProp;
        }
        return null;
    }

    @Nullable
    private List<File> initializeResourceLocations() {
        String searchPath = this.detectSearchPath();
        if (searchPath != null) {
            ArrayList<File> locations = new ArrayList<File>();
            String[] stringArray = searchPath.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                try {
                    File dir = new File(segment).getCanonicalFile();
                    if (dir.exists() && dir.isDirectory()) {
                        locations.add(dir);
                    } else {
                        this.log.warn("Invalid search-path segment: {}; ignoring", (Object)segment);
                    }
                }
                catch (Exception e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
                ++n2;
            }
            if (!locations.isEmpty()) {
                return locations;
            }
        }
        return null;
    }

    @Nullable
    public List<File> getResourceLocations() {
        return this.resourceLocations;
    }

    @Nullable
    public File getFileIfOnFileSystem(String path) {
        if (this.resourceLocations != null) {
            for (File dir : this.resourceLocations) {
                File file = new File(dir, path);
                if (!file.exists()) continue;
                return file;
            }
        }
        return null;
    }
}

