/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.wonderland;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.internal.wonderland.AuthTicketCache;
import org.sonatype.nexus.internal.wonderland.AuthTicketGenerator;

@Named
@Singleton
public class AuthTicketServiceImpl
extends ComponentSupport
implements AuthTicketService {
    private final AuthTicketGenerator authTicketGenerator;
    private final AuthTicketCache authTicketCache;

    @Inject
    public AuthTicketServiceImpl(AuthTicketGenerator authTicketGenerator, AuthTicketCache authTicketCache) {
        this.authTicketGenerator = (AuthTicketGenerator)((Object)Preconditions.checkNotNull((Object)((Object)authTicketGenerator)));
        this.authTicketCache = (AuthTicketCache)((Object)Preconditions.checkNotNull((Object)((Object)authTicketCache)));
    }

    public String createTicket(String user) {
        String ticket = this.authTicketGenerator.generate();
        this.authTicketCache.add(user, ticket);
        return ticket;
    }

    @Nullable
    public String createTicket() {
        Subject subject = SecurityUtils.getSubject();
        return subject != null ? this.createTicket(subject.getPrincipal().toString()) : null;
    }

    public boolean redeemTicket(String user, String ticket) {
        Preconditions.checkNotNull((Object)ticket);
        return this.authTicketCache.remove(user, ticket);
    }

    public boolean redeemTicket(String ticket) {
        Subject subject = SecurityUtils.getSubject();
        return subject != null && this.redeemTicket(subject.getPrincipal().toString(), ticket);
    }
}

