/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.internal.wonderland;

import com.google.common.base.Preconditions;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import java.io.FileInputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationDirectories;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.common.wonderland.DownloadService;

@Named(value="default")
@Singleton
public class DownloadServiceImpl
extends ComponentSupport
implements DownloadService,
GroovyObject {
    private static final AtomicLong counter;
    private final File downloadDir;
    private final AuthTicketService authTickets;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    @Inject
    public DownloadServiceImpl(ApplicationDirectories applicationDirectories, AuthTicketService authTicketService) {
        void authTicketService2;
        void applicationDirectories2;
        MetaClass metaClass;
        CallSite[] callSiteArray = DownloadServiceImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
        callSiteArray[0].callStatic(Preconditions.class, (Object)applicationDirectories2);
        Object object = callSiteArray[1].callStatic(Preconditions.class, (Object)authTicketService2);
        this.authTickets = (AuthTicketService)ScriptBytecodeAdapter.castToType((Object)object, AuthTicketService.class);
        Object object2 = callSiteArray[2].call((Object)applicationDirectories2, (Object)"downloads");
        this.downloadDir = (File)ScriptBytecodeAdapter.castToType((Object)object2, File.class);
        callSiteArray[3].call(callSiteArray[4].callGroovyObjectGetProperty((Object)this), (Object)"Downloads directory: {}", (Object)this.downloadDir);
    }

    public DownloadService.Download get(String fileName, String authTicket) {
        CallSite[] callSiteArray = DownloadServiceImpl.$getCallSiteArray();
        callSiteArray[5].call(callSiteArray[6].callGroovyObjectGetProperty((Object)this), (Object)"Download: {}", (Object)fileName);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call((Object)this.authTickets, (Object)authTicket))) {
            throw (Throwable)callSiteArray[8].callConstructor(IllegalArgumentException.class, (Object)"Invalid authentication ticket");
        }
        Object file = callSiteArray[9].callConstructor(File.class, (Object)this.downloadDir, (Object)fileName);
        callSiteArray[10].callCurrent((GroovyObject)this, file);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[11].call(file)) && DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[12].call(file))) {
            callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this), (Object)"File {} not found in download directory (or is not a file)", file);
            return (DownloadService.Download)ScriptBytecodeAdapter.castToType(null, DownloadService.Download.class);
        }
        return (DownloadService.Download)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].callConstructor(DownloadService.Download.class, callSiteArray[16].call(file), callSiteArray[17].callConstructor(FileInputStream.class, file)), DownloadService.Download.class);
    }

    public String move(File source, String name) {
        CallSite[] callSiteArray = DownloadServiceImpl.$getCallSiteArray();
        Object target = callSiteArray[18].callConstructor(File.class, (Object)this.downloadDir, (Object)name);
        callSiteArray[19].callCurrent((GroovyObject)this, target);
        callSiteArray[20].call(Files.class, callSiteArray[21].call((Object)source), callSiteArray[22].call(target));
        callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)this), (Object)"Moved {} to {}", (Object)source, target);
        return ShortTypeHandling.castToString((Object)callSiteArray[25].call(target));
    }

    public String uniqueName(String prefix) {
        CallSite[] callSiteArray = DownloadServiceImpl.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[26].call(callSiteArray[27].call(callSiteArray[28].call((Object)prefix, callSiteArray[29].call(callSiteArray[30].callConstructor(SimpleDateFormat.class, (Object)"yyyyMMdd-HHmmss"), callSiteArray[31].callConstructor(Date.class))), (Object)"-"), callSiteArray[32].call((Object)counter)));
    }

    private void ensureWithinDownloads(File file) {
        CallSite[] callSiteArray = DownloadServiceImpl.$getCallSiteArray();
        callSiteArray[33].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[34].callGetProperty((Object)file), (Object)this.downloadDir), (Object)new GStringImpl(new Object[]{file}, new String[]{"Reference outside of downloads dir: ", ""}));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != DownloadServiceImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = DownloadServiceImpl.$getCallSiteArray()[35].callConstructor(AtomicLong.class);
        counter = (AtomicLong)ScriptBytecodeAdapter.castToType((Object)object, AtomicLong.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "checkNotNull";
        stringArray[1] = "checkNotNull";
        stringArray[2] = "getWorkDirectory";
        stringArray[3] = "info";
        stringArray[4] = "log";
        stringArray[5] = "info";
        stringArray[6] = "log";
        stringArray[7] = "redeemTicket";
        stringArray[8] = "<$constructor$>";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "ensureWithinDownloads";
        stringArray[11] = "exists";
        stringArray[12] = "isFile";
        stringArray[13] = "warn";
        stringArray[14] = "log";
        stringArray[15] = "<$constructor$>";
        stringArray[16] = "length";
        stringArray[17] = "<$constructor$>";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "ensureWithinDownloads";
        stringArray[20] = "move";
        stringArray[21] = "toPath";
        stringArray[22] = "toPath";
        stringArray[23] = "debug";
        stringArray[24] = "log";
        stringArray[25] = "getAbsolutePath";
        stringArray[26] = "plus";
        stringArray[27] = "plus";
        stringArray[28] = "plus";
        stringArray[29] = "format";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "incrementAndGet";
        stringArray[33] = "checkArgument";
        stringArray[34] = "parentFile";
        stringArray[35] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[36];
        DownloadServiceImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DownloadServiceImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DownloadServiceImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

