/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.gossip.support;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;

public class MuxLoggerFactory {
    public static Logger create(Logger ... loggers) {
        return (Logger)Proxy.newProxyInstance(Logger.class.getClassLoader(), new Class[]{Logger.class}, (InvocationHandler)new Handler(loggers));
    }

    private static class Handler
    implements InvocationHandler {
        private final Logger[] loggers;

        private Handler(Logger[] loggers) {
            assert (loggers != null);
            assert (loggers.length > 0);
            this.loggers = loggers;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            assert (proxy != null);
            assert (method != null);
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke((Object)this, args);
            }
            if (method.getReturnType() != Void.TYPE) {
                return method.invoke((Object)this.loggers[0], args);
            }
            for (Logger logger : this.loggers) {
                method.invoke((Object)logger, args);
            }
            return null;
        }
    }
}

