/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.blobstore.restore.pypi.internal;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.blobstore.restore.BaseRestoreBlobStrategy;
import org.sonatype.nexus.blobstore.restore.RestoreBlobData;
import org.sonatype.nexus.blobstore.restore.pypi.internal.PyPiRestoreBlobData;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.log.DryRunPrefix;
import org.sonatype.nexus.common.node.NodeAccess;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.pypi.PyPiFacet;
import org.sonatype.nexus.repository.pypi.repair.PyPiRepairIndexComponent;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.Transactional;

@Named(value="pypi")
@Singleton
public class PyPiRestoreBlobStrategy
extends BaseRestoreBlobStrategy<PyPiRestoreBlobData> {
    private final PyPiRepairIndexComponent pyPiRepairIndexComponent;

    @Inject
    public PyPiRestoreBlobStrategy(NodeAccess nodeAccess, RepositoryManager repositoryManager, BlobStoreManager blobStoreManager, DryRunPrefix dryRunPrefix, PyPiRepairIndexComponent pyPiRepairIndexComponent) {
        super(nodeAccess, repositoryManager, blobStoreManager, dryRunPrefix);
        this.pyPiRepairIndexComponent = pyPiRepairIndexComponent;
    }

    protected PyPiRestoreBlobData createRestoreData(RestoreBlobData blobData) {
        return new PyPiRestoreBlobData(blobData);
    }

    protected boolean canAttemptRestore(PyPiRestoreBlobData data) {
        Repository repository = data.getBlobData().getRepository();
        if (!repository.optionalFacet(PyPiFacet.class).isPresent()) {
            this.log.warn("Skipping as PyPI Facet not found on repository: {}", (Object)repository.getName());
            return false;
        }
        return true;
    }

    protected String getAssetPath(PyPiRestoreBlobData data) {
        return data.getBlobData().getBlobName();
    }

    @Transactional
    protected boolean assetExists(PyPiRestoreBlobData data) throws IOException {
        return ((PyPiFacet)data.getBlobData().getRepository().facet(PyPiFacet.class)).assetExists(this.getAssetPath(data));
    }

    @TransactionalStoreMetadata
    protected void createAssetFromBlob(AssetBlob assetBlob, PyPiRestoreBlobData data) throws IOException {
        ((PyPiFacet)data.getBlobData().getRepository().facet(PyPiFacet.class)).put(this.getAssetPath(data), assetBlob);
    }

    public void after(boolean updateAssets, Repository repository) {
        if (updateAssets) {
            this.pyPiRepairIndexComponent.repairRepository(repository);
        } else {
            this.log.info("Updating assets disabled so not running repair of PyPi package metadata");
        }
    }

    protected List<HashAlgorithm> getHashAlgorithms() {
        return ImmutableList.of((Object)HashAlgorithm.SHA1, (Object)HashAlgorithm.SHA256, (Object)HashAlgorithm.MD5);
    }
}

