/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.blobstore.restore.internal;

import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.blobstore.restore.DefaultIntegrityCheckStrategy;
import org.sonatype.nexus.blobstore.restore.IntegrityCheckStrategy;
import org.sonatype.nexus.repository.storage.Asset;

@Named(value="nuget")
@Singleton
public class NugetIntegrityCheckStrategy
extends DefaultIntegrityCheckStrategy
implements IntegrityCheckStrategy {
    static final String BAD_FORMAT = "Asset name '%s' not in expected Nuget format of 'name/version'";

    protected String getAssetName(Asset asset) {
        String assetName = super.getAssetName(asset);
        int slashPos = assetName.lastIndexOf(47);
        if (slashPos == -1) {
            throw new IllegalArgumentException(String.format(BAD_FORMAT, assetName));
        }
        return String.valueOf(assetName.substring(0, slashPos)) + "-" + assetName.substring(slashPos + 1) + ".nupkg";
    }
}

