/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.ssl.internal;

import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class ReloadableX509TrustManager
implements X509TrustManager {
    private X509TrustManager delegateTrustManager;

    private ReloadableX509TrustManager(X509TrustManager delegateTrustManager) {
        this.setDelegateTrustManager(delegateTrustManager);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.delegateTrustManager.checkClientTrusted(x509Certificates, s);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        this.delegateTrustManager.checkServerTrusted(x509Certificates, s);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegateTrustManager.getAcceptedIssuers();
    }

    private void setDelegateTrustManager(X509TrustManager delegateTrustManager) {
        this.delegateTrustManager = delegateTrustManager;
    }

    public static ReloadableX509TrustManager replaceX509TrustManager(ReloadableX509TrustManager reloadableX509TrustManager, TrustManager[] trustManagers) throws NoSuchAlgorithmException {
        int ii = 0;
        while (ii < trustManagers.length) {
            if (ReloadableX509TrustManager.class.isInstance(trustManagers[ii])) {
                throw new IllegalStateException("A ReloadableX509TrustManager has already been set for this TrustManager[]");
            }
            if (X509TrustManager.class.isInstance(trustManagers[ii])) {
                if (reloadableX509TrustManager == null) {
                    reloadableX509TrustManager = new ReloadableX509TrustManager((X509TrustManager)trustManagers[ii]);
                } else {
                    reloadableX509TrustManager.setDelegateTrustManager((X509TrustManager)trustManagers[ii]);
                }
                trustManagers[ii] = reloadableX509TrustManager;
                return reloadableX509TrustManager;
            }
            ++ii;
        }
        throw new NoSuchAlgorithmException("No X509TrustManager found in TrustManager[]");
    }
}

