/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationAssistant;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.goodies.lifecycle.Lifecycle;
import org.sonatype.goodies.lifecycle.LifecycleManager;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;

@Named
@Singleton
public class MigrationServiceImpl
extends StateGuardLifecycleSupport
implements MigrationService {
    private final RepositoryMigrationManager repositoryMigrationManager;
    private final Provider<MigrationAssistant> assistantFactory;
    private final LifecycleManager lifecycles = new LifecycleManager();
    private MigrationAssistant assistant;

    @Inject
    public MigrationServiceImpl(RepositoryMigrationManager repositoryMigrationManager, Provider<MigrationAssistant> assistantFactory) {
        this.repositoryMigrationManager = (RepositoryMigrationManager)Preconditions.checkNotNull((Object)repositoryMigrationManager);
        this.assistantFactory = (Provider)Preconditions.checkNotNull(assistantFactory);
        this.lifecycles.add((Lifecycle)repositoryMigrationManager);
    }

    protected void doStart() throws Exception {
        this.lifecycles.start();
        this.assistant = (MigrationAssistant)this.assistantFactory.get();
        this.log.info("Created assistant: {}", (Object)this.assistant);
        this.assistant.start();
    }

    protected void doStop() throws Exception {
        this.assistant.stop();
        this.assistant = null;
        this.lifecycles.stop();
    }

    @Override
    public boolean isEnabled() {
        return this.isStarted();
    }

    @Override
    @Guarded(by={"STARTED"})
    public MigrationAssistant getAssistant() {
        return this.assistant;
    }
}

