/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.firewall;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.sonatype.nexus.clm.migration.FirewallMigrationHelper;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.client.RepositoryClient;
import com.sonatype.nexus.migration.firewall.FirewallCloneRequest;
import com.sonatype.nexus.migration.firewall.FirewallMigrationFacade;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreMetadata;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named
@Singleton
@Priority(value=0x7FFFFFFF)
public class EnabledFirewallMigrationFacadeImpl
extends ComponentSupport
implements FirewallMigrationFacade {
    private static final int INITIAL_DELAY_MILLIS = 30000;
    private static final int MAXIMUM_DELAY_MILLIS = 300000;
    private static final String IQ_REPOSITORY_ATTRIBUTES = "iqRepositoryAttributes";
    private static final String IQ_ITEM_ATTRIBUTES = "iqItemAttributes";
    private static final TypeToken<Map<String, Object>> IQ_ITEM_ATTRIBUTES_TYPE = new TypeToken<Map<String, Object>>(){};
    private final FirewallMigrationHelper firewallMigrationHelper;
    private final RepositoryManager repositoryManager;

    @Inject
    public EnabledFirewallMigrationFacadeImpl(FirewallMigrationHelper firewallMigrationHelper, RepositoryManager repositoryManager) {
        this.firewallMigrationHelper = (FirewallMigrationHelper)Preconditions.checkNotNull((Object)firewallMigrationHelper);
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
    }

    @Override
    public void verifyConnection() throws IOException {
        this.log.debug("Verifying connection to IQ Server");
        this.firewallMigrationHelper.verifyConnection();
    }

    @Override
    public List<FirewallCloneRequest> prepareCloning(Collection<String> selectedRepositories) {
        Preconditions.checkNotNull(selectedRepositories);
        return selectedRepositories.stream().map(arg_0 -> ((RepositoryManager)this.repositoryManager).get(arg_0)).filter(arg_0 -> ((FirewallMigrationHelper)this.firewallMigrationHelper).isAuditEnabled(arg_0)).map(repository -> new FirewallCloneRequest((Repository)repository, FirewallCloneRequest.Status.BEGIN, 30000L, 300000L)).collect(Collectors.toList());
    }

    @Override
    public List<FirewallCloneRequest> processCloning(Collection<FirewallCloneRequest> requests) {
        Preconditions.checkNotNull(requests);
        return requests.stream().map(this::processRequest).collect(Collectors.toList());
    }

    private FirewallCloneRequest processRequest(FirewallCloneRequest request) {
        FirewallCloneRequest result = this.processRequestIfReady(request);
        if (result.isChanged()) {
            this.log.debug("Repository {} status has changed from {} to {}", new Object[]{request.getRepository().getName(), request.getStatus(), result.getStatus()});
        }
        return result;
    }

    private FirewallCloneRequest processRequestIfReady(FirewallCloneRequest request) {
        if (!request.isReady()) {
            return request.transitionTo(request.getStatus(), request.getMessage());
        }
        switch (request.getStatus()) {
            case BEGIN: {
                return this.requestCloning(request);
            }
            case REQUESTED: {
                return this.pollStatus(request);
            }
            case RUNNING: {
                return this.pollStatus(request);
            }
            case COMPLETED: {
                return request.transitionTo(FirewallCloneRequest.Status.COMPLETED, request.getMessage());
            }
            case FAILED: {
                return request.transitionTo(FirewallCloneRequest.Status.BEGIN, "Retrying clone operation");
            }
            case IO_ERROR_CLONING: {
                return request.transitionTo(FirewallCloneRequest.Status.BEGIN, "Retrying clone operation");
            }
            case IO_ERROR_POLLING: {
                return request.transitionTo(FirewallCloneRequest.Status.REQUESTED, "Retrying polling operation");
            }
        }
        throw new IllegalStateException("Unexpected IQ violation history clone status " + (Object)((Object)request.getStatus()) + " for repository " + request.getRepository().getName());
    }

    private FirewallCloneRequest requestCloning(FirewallCloneRequest request) {
        Repository repository = request.getRepository();
        try {
            this.firewallMigrationHelper.cloneRepositoryHistory(repository);
            return request.transitionTo(FirewallCloneRequest.Status.REQUESTED, "");
        }
        catch (IOException e) {
            this.log.debug("Error requesting clone of IQ violation history for repository {}", (Object)repository.getName(), (Object)e);
            return request.transitionTo(FirewallCloneRequest.Status.IO_ERROR_CLONING, e.getMessage());
        }
    }

    private FirewallCloneRequest pollStatus(FirewallCloneRequest request) {
        Repository repository = request.getRepository();
        try {
            FirewallMigrationHelper.State state = this.firewallMigrationHelper.getRepositoryCloneState(repository);
            switch (state) {
                case RUNNING: {
                    return request.transitionTo(FirewallCloneRequest.Status.RUNNING, "");
                }
                case COMPLETED: {
                    return request.transitionTo(FirewallCloneRequest.Status.COMPLETED, "");
                }
                case FAILED: {
                    return request.transitionTo(FirewallCloneRequest.Status.FAILED, "Check IQ logs for failure details");
                }
            }
            throw new IllegalStateException("Repository " + repository.getName() + " returned unexpected IQ status " + state);
        }
        catch (IOException e) {
            this.log.debug("Error polling IQ for repository {}", (Object)repository.getName(), (Object)e);
            return request.transitionTo(FirewallCloneRequest.Status.IO_ERROR_POLLING, e.getMessage());
        }
    }

    @Override
    public boolean isAuditEnabled(Repository repository) {
        Preconditions.checkNotNull((Object)repository);
        return this.firewallMigrationHelper.isAuditEnabled(repository);
    }

    @Override
    public boolean shouldAuditBeEnabled(Map<String, Object> attributes) {
        Preconditions.checkNotNull(attributes);
        return this.firewallMigrationHelper.shouldAuditBeEnabled(attributes);
    }

    @Override
    public void maybeRecordRepositoryFirewallAttributes(Repository repository, RepositoryClient.RepositoryDetailXO repositoryDetail) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)repositoryDetail);
        Map<String, Object> attributes = repositoryDetail.getAttributes();
        if (attributes.containsKey(IQ_REPOSITORY_ATTRIBUTES)) {
            Map iqAttributes = (Map)attributes.get(IQ_REPOSITORY_ATTRIBUTES);
            this.firewallMigrationHelper.createFirewallCapability(repository, iqAttributes);
            ((AttributesFacet)repository.facet(AttributesFacet.class)).modifyAttributes(change -> this.firewallMigrationHelper.ingestRepositoryAttributes(repository.getName(), change, iqAttributes));
        }
    }

    @Override
    public void maybeRecordAssetAttributes(Repository repository, RepositoryChangelogClient.ChangeEntryXO change, Function<StorageTx, Asset> assetLoader) {
        Preconditions.checkNotNull((Object)repository);
        Preconditions.checkNotNull((Object)change);
        Preconditions.checkNotNull(assetLoader);
        NestedAttributesMap assetAttributes = change.getChange().getAsset().attributes();
        Map iqAttributes = (Map)assetAttributes.get(IQ_ITEM_ATTRIBUTES, IQ_ITEM_ATTRIBUTES_TYPE);
        if (iqAttributes != null) {
            TransactionalStoreMetadata.operation.withDb(((StorageFacet)repository.facet(StorageFacet.class)).txSupplier()).run(() -> this.updateAssetAttributes(assetLoader, iqAttributes));
        }
    }

    @Override
    public void maybeActivateFirewallCapability(Repository repository) {
        if (this.isAuditEnabled(repository)) {
            this.firewallMigrationHelper.activateFirewallCapability(repository);
        }
    }

    private void updateAssetAttributes(Function<StorageTx, Asset> assetLoader, Map<String, Object> iqAttributes) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Asset asset = assetLoader.apply(tx);
        if (asset != null) {
            this.firewallMigrationHelper.ingestAssetAttributes(asset, iqAttributes);
            tx.saveAsset(asset);
        }
    }
}

