/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.firewall;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.nexus.repository.Repository;

public class FirewallCloneRequest {
    private static final long RETRY_FACTOR = 2L;
    private final Repository repository;
    private final Status status;
    private final String message;
    private final long initialDelay;
    private final long presentDelay;
    private final long maximumDelay;
    private final DateTime retryAt;
    private final boolean changed;

    FirewallCloneRequest(Repository repository, Status code, long initialDelay, long maximumDelay) {
        this(repository, code, "", initialDelay, initialDelay, maximumDelay, DateTime.now(), false);
    }

    private FirewallCloneRequest(Repository repository, Status status, String message, long initialDelay, long presentDelay, long maximumDelay, DateTime retryAt, boolean changed) {
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.status = (Status)((Object)Preconditions.checkNotNull((Object)((Object)status)));
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.initialDelay = initialDelay;
        this.presentDelay = presentDelay;
        this.maximumDelay = maximumDelay;
        this.retryAt = (DateTime)Preconditions.checkNotNull((Object)retryAt);
        this.changed = changed;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public DateTime getRetryAt() {
        return this.retryAt;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public boolean isReady() {
        return this.isReady(DateTime.now());
    }

    public boolean isRecoveringFromFailure() {
        return this.presentDelay > this.initialDelay;
    }

    @VisibleForTesting
    boolean isReady(DateTime now) {
        Preconditions.checkNotNull((Object)now);
        switch (this.status) {
            case BEGIN: 
            case REQUESTED: 
            case RUNNING: {
                return true;
            }
            case COMPLETED: {
                return false;
            }
            case FAILED: 
            case IO_ERROR_CLONING: 
            case IO_ERROR_POLLING: {
                return now.isAfter((ReadableInstant)this.retryAt);
            }
        }
        throw new IllegalStateException("Unexpected status: " + (Object)((Object)this.status));
    }

    public FirewallCloneRequest transitionTo(Status newStatus, String newMessage) {
        Preconditions.checkNotNull((Object)((Object)newStatus));
        Preconditions.checkNotNull((Object)newMessage);
        if (this.status.equals((Object)newStatus)) {
            return this.transitionToSameStatus(newMessage);
        }
        return this.transitionToDifferentStatus(newStatus, newMessage);
    }

    private FirewallCloneRequest transitionToSameStatus(String newMessage) {
        return new FirewallCloneRequest(this.repository, this.status, newMessage, this.initialDelay, this.presentDelay, this.maximumDelay, this.retryAt, false);
    }

    private FirewallCloneRequest transitionToDifferentStatus(Status newStatus, String newMessage) {
        long newPresentDelay;
        DateTime newRetryAt;
        switch (newStatus) {
            case FAILED: 
            case IO_ERROR_CLONING: 
            case IO_ERROR_POLLING: {
                newRetryAt = DateTime.now().plus(this.presentDelay);
                newPresentDelay = Math.min(this.presentDelay * 2L, this.maximumDelay);
                break;
            }
            case BEGIN: 
            case REQUESTED: {
                newRetryAt = this.retryAt;
                newPresentDelay = this.presentDelay;
                break;
            }
            case RUNNING: 
            case COMPLETED: {
                newRetryAt = this.retryAt;
                newPresentDelay = this.initialDelay;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected status: " + (Object)((Object)this.status));
            }
        }
        return new FirewallCloneRequest(this.repository, newStatus, newMessage, this.initialDelay, newPresentDelay, this.maximumDelay, newRetryAt, true);
    }

    public static enum Status {
        BEGIN,
        REQUESTED,
        RUNNING,
        COMPLETED,
        FAILED,
        IO_ERROR_CLONING,
        IO_ERROR_POLLING;

    }
}

