/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.legacyurl;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.sonatype.nexus.migration.legacyurl.LegacyUrlEnabler;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.repository.httpbridge.legacy.LegacyUrlCapabilityDescriptor;

@Named
@Singleton
public class LegacyUrlEnablerImpl
implements LegacyUrlEnabler {
    private final CapabilityRegistry capabilityRegistry;

    @Inject
    public LegacyUrlEnablerImpl(CapabilityRegistry capabilityRegistry) {
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
    }

    @Override
    public void enable() {
        CapabilityReference legacyUrlCapability = this.getLegacyUrlCapability();
        if (legacyUrlCapability == null) {
            legacyUrlCapability = this.capabilityRegistry.add(LegacyUrlCapabilityDescriptor.TYPE, false, "Automatically added on " + new Date(), null);
        }
        if (!legacyUrlCapability.context().isEnabled()) {
            this.capabilityRegistry.enable(legacyUrlCapability.context().id());
        }
    }

    @Nullable
    private CapabilityReference getLegacyUrlCapability() {
        Collection references = this.capabilityRegistry.get((Predicate)CapabilityReferenceFilterBuilder.capabilities().withType(LegacyUrlCapabilityDescriptor.TYPE));
        if (references.isEmpty()) {
            return null;
        }
        return (CapabilityReference)references.iterator().next();
    }
}

