/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Supplier;

public class BufferingIterator<T>
implements Iterator<T> {
    private final Queue<T> buffer = new LinkedList<T>();
    private final Supplier<Iterable<T>> filler;

    public BufferingIterator(Supplier<Iterable<T>> refiller) {
        this.filler = (Supplier)Preconditions.checkNotNull(refiller);
    }

    @Override
    public boolean hasNext() {
        this.ensureBufferFilled();
        return !this.buffer.isEmpty();
    }

    @Override
    public T next() {
        this.ensureBufferFilled();
        return Optional.of(this.buffer.poll()).orElseThrow(() -> new NoSuchElementException());
    }

    private void ensureBufferFilled() {
        if (this.buffer.isEmpty()) {
            this.fillBuffer();
        }
    }

    private void fillBuffer() {
        this.filler.get().forEach(item -> {
            boolean bl = this.buffer.add(item);
        });
    }
}

