/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.hash.Hashing;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.client.RepositoryClient;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.IngestionValidation;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.blobstore.api.BlobStore;
import org.sonatype.nexus.blobstore.api.BlobStoreException;
import org.sonatype.nexus.blobstore.api.BlobStoreManager;
import org.sonatype.nexus.common.io.DirectoryHelper;
import org.sonatype.nexus.security.ClientInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
public class IngestionValidationImpl
extends ComponentSupport
implements IngestionValidation,
GroovyObject {
    @Inject
    private MigrationService migrationService;
    @Inject
    private RepositoryClient repositoryClient;
    @Inject
    private ClientInfoProvider clientInfoProvider;
    @Inject
    private BlobStoreManager blobStoreManager;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public IngestionValidationImpl() {
        MetaClass metaClass;
        CallSite[] callSiteArray = IngestionValidationImpl.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public Set<IngestMethod> availableMethods(String repositoryName, String blobStoreName) {
        byte[] bytes;
        Object testContentPath;
        Object testContent;
        Set availableMethods;
        Object blobStore;
        CallSite[] callSiteArray;
        block16: {
            callSiteArray = IngestionValidationImpl.$getCallSiteArray();
            blobStore = callSiteArray[0].call((Object)this.blobStoreManager, (Object)blobStoreName);
            callSiteArray[1].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)blobStore, null), (Object)"Missing blob-store: %s", blobStore);
            availableMethods = (Set)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[2].callGetProperty(IngestMethod.class)}), Set.class);
            testContent = callSiteArray[3].call((Object)this.repositoryClient, callSiteArray[4].callGetProperty((Object)this.migrationService), (Object)repositoryName);
            if (!DefaultTypeTransformation.booleanUnbox((Object)testContent)) {
                return (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[5].call(IngestMethod.class), Set.class);
            }
            testContentPath = callSiteArray[6].call(Paths.class, callSiteArray[7].callGetProperty(testContent));
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[8].call(Files.class, testContentPath))) {
                callSiteArray[9].call(callSiteArray[10].callGroovyObjectGetProperty((Object)this), (Object)"Cannot access test file {} from this process", testContentPath);
                return availableMethods;
            }
            bytes = null;
            Object object = callSiteArray[11].call(testContentPath);
            bytes = (byte[])ScriptBytecodeAdapter.castToType((Object)object, byte[].class);
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[12].callGetProperty(testContent), (Object)bytes)) {
                callSiteArray[13].call((Object)availableMethods, callSiteArray[14].callGetProperty(IngestMethod.class));
                break block16;
            }
            callSiteArray[15].call(callSiteArray[16].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{testContentPath}, new String[]{"Unexpected test content found in ", ""}));
            Set set = availableMethods;
            try {
                return set;
            }
            catch (IOException e) {
                callSiteArray[17].call(callSiteArray[18].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{testContentPath}, new String[]{"Unable to open input stream to ", ": {}"}), callSiteArray[19].call((Object)e));
            }
        }
        try {
            Object[] objectArray = new Object[4];
            objectArray[0] = callSiteArray[21].callGetProperty(BlobStore.class);
            objectArray[1] = ShortTypeHandling.castToString((Object)callSiteArray[22].callGetProperty(testContent));
            objectArray[2] = callSiteArray[23].callGetProperty(BlobStore.class);
            Object object = callSiteArray[24].callGetPropertySafe(callSiteArray[25].callGetProperty((Object)this.clientInfoProvider));
            objectArray[3] = ShortTypeHandling.castToString((Object)(DefaultTypeTransformation.booleanUnbox((Object)object) ? object : "system"));
            Object blob = callSiteArray[20].call(blobStore, testContentPath, (Object)ScriptBytecodeAdapter.createMap((Object[])objectArray), callSiteArray[26].callGetProperty((Object)bytes), callSiteArray[27].call(callSiteArray[28].call(Hashing.class), (Object)bytes));
            callSiteArray[29].call(blobStore, callSiteArray[30].callGetProperty(blob), (Object)"Cleanup ingestion validation");
            callSiteArray[31].call((Object)availableMethods, callSiteArray[32].callGetProperty(IngestMethod.class));
        }
        catch (BlobStoreException e) {
            callSiteArray[33].call(callSiteArray[34].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{testContentPath}, new String[]{"Unable to create hard link to ", ": {}"}), callSiteArray[35].call(callSiteArray[36].call(Throwables.class, (Object)e)));
        }
        try {
            callSiteArray[37].call(DirectoryHelper.class, testContentPath);
        }
        catch (Exception ignored) {
            callSiteArray[38].call(callSiteArray[39].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{testContentPath}, new String[]{"Unable to delete remote test content ", ""}));
        }
        return availableMethods;
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IngestionValidationImpl.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    public RepositoryClient getRepositoryClient() {
        return this.repositoryClient;
    }

    public void setRepositoryClient(RepositoryClient repositoryClient) {
        this.repositoryClient = repositoryClient;
    }

    public ClientInfoProvider getClientInfoProvider() {
        return this.clientInfoProvider;
    }

    public void setClientInfoProvider(ClientInfoProvider clientInfoProvider) {
        this.clientInfoProvider = clientInfoProvider;
    }

    public BlobStoreManager getBlobStoreManager() {
        return this.blobStoreManager;
    }

    public void setBlobStoreManager(BlobStoreManager blobStoreManager) {
        this.blobStoreManager = blobStoreManager;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "get";
        stringArray[1] = "checkState";
        stringArray[2] = "DOWNLOAD";
        stringArray[3] = "createTestContent";
        stringArray[4] = "assistant";
        stringArray[5] = "values";
        stringArray[6] = "get";
        stringArray[7] = "path";
        stringArray[8] = "exists";
        stringArray[9] = "debug";
        stringArray[10] = "log";
        stringArray[11] = "getBytes";
        stringArray[12] = "content";
        stringArray[13] = "add";
        stringArray[14] = "FS_COPY";
        stringArray[15] = "info";
        stringArray[16] = "log";
        stringArray[17] = "debug";
        stringArray[18] = "log";
        stringArray[19] = "toString";
        stringArray[20] = "create";
        stringArray[21] = "BLOB_NAME_HEADER";
        stringArray[22] = "path";
        stringArray[23] = "CREATED_BY_HEADER";
        stringArray[24] = "userid";
        stringArray[25] = "currentThreadClientInfo";
        stringArray[26] = "length";
        stringArray[27] = "hashBytes";
        stringArray[28] = "sha1";
        stringArray[29] = "delete";
        stringArray[30] = "id";
        stringArray[31] = "add";
        stringArray[32] = "FS_LINK";
        stringArray[33] = "debug";
        stringArray[34] = "log";
        stringArray[35] = "toString";
        stringArray[36] = "getRootCause";
        stringArray[37] = "deleteIfExists";
        stringArray[38] = "info";
        stringArray[39] = "log";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[40];
        IngestionValidationImpl.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(IngestionValidationImpl.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = IngestionValidationImpl.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

