/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationPhases;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.client.http.MigrationDisconnectionEvent;
import com.sonatype.nexus.migration.client.http.MigrationReconnectionEvent;
import com.sonatype.nexus.migration.client.http.RequestMonitorController;
import com.sonatype.nexus.migration.plan.Step;
import com.sonatype.nexus.migration.repository.BufferingIterator;
import com.sonatype.nexus.migration.repository.CompletionOrderHelper;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.time.TimeCategory;
import groovy.time.TimeDuration;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.thread.NexusThreadFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="migration.process-changes")
public class ProcessChangesStep
extends Step {
    public static final String TYPE_NAME = "migration.process-changes";
    public static final int DEFAULT_PROCESSING_THREADS;
    private static final Time ADDITIONAL_CHANGES_CHECK_DELAY;
    @Inject
    private MigrationService migrationService;
    @Inject
    private RepositoryMigrationManager repositoryMigrationManager;
    @Inject
    private RepositoryChangelogClient repositoryChangelogClient;
    @Inject
    private RequestMonitorController httpController;
    @Inject
    private EventManager eventManager;
    private RepositoryChangelogClient.ChangelogConnection changelogConnection;
    private AtomicReference<String> lastProcessedChangeId;
    private ExecutorService processingThreads;
    private BlockingQueue<ProcessingResult> results;
    private final CompletionOrderHelper<String> completionOrder;
    private int totalCount;
    private int threadCount;
    private int failedCount;
    private AtomicBoolean waitingForChanges;
    private AtomicBoolean stopWaiting;
    private static final int CHANGELOG_FETCH_SIZE = 100;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public ProcessChangesStep() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(AtomicReference.class);
        this.lastProcessedChangeId = (AtomicReference)ScriptBytecodeAdapter.castToType((Object)object, AtomicReference.class);
        Object object2 = callSiteArray[1].callConstructor(CompletionOrderHelper.class);
        this.completionOrder = (CompletionOrderHelper)ScriptBytecodeAdapter.castToType((Object)object2, CompletionOrderHelper.class);
        Object object3 = callSiteArray[2].callConstructor(AtomicBoolean.class, (Object)false);
        this.waitingForChanges = (AtomicBoolean)ScriptBytecodeAdapter.castToType((Object)object3, AtomicBoolean.class);
        Object object4 = callSiteArray[3].callConstructor(AtomicBoolean.class, (Object)false);
        this.stopWaiting = (AtomicBoolean)ScriptBytecodeAdapter.castToType((Object)object4, AtomicBoolean.class);
    }

    @Override
    public String getType() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return TYPE_NAME;
    }

    @Override
    protected void doConfigure(Map<String, Object> config) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object object = callSiteArray[4].callGetProperty(MigrationPhases.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProcessChangesStep.class, (GroovyObject)this, (String)"phase");
        String string = "Process changes";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProcessChangesStep.class, (GroovyObject)this, (String)"name");
    }

    @Override
    protected void doInit() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object assistant = callSiteArray[5].callGetProperty((Object)this.migrationService);
        Object object = callSiteArray[6].call((Object)this.repositoryChangelogClient, assistant);
        this.changelogConnection = (RepositoryChangelogClient.ChangelogConnection)ScriptBytecodeAdapter.castToType((Object)object, RepositoryChangelogClient.ChangelogConnection.class);
        Object object2 = callSiteArray[7].call(SystemPropertiesHelper.class, callSiteArray[8].call(callSiteArray[9].callGetProperty(ProcessChangesStep.class), (Object)".threads"), (Object)DEFAULT_PROCESSING_THREADS);
        this.threadCount = DefaultTypeTransformation.intUnbox((Object)object2);
        callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this), (Object)new GStringImpl(new Object[]{this.threadCount}, new String[]{"Processing changes using ", " threads"}));
        Object object3 = callSiteArray[12].call(Executors.class, (Object)this.threadCount, callSiteArray[13].callConstructor(NexusThreadFactory.class, (Object)"change-processing", (Object)"migration"));
        this.processingThreads = (ExecutorService)ScriptBytecodeAdapter.castToType((Object)object3, ExecutorService.class);
        Object object4 = callSiteArray[14].callConstructor(ArrayBlockingQueue.class, (Object)this.threadCount);
        this.results = (BlockingQueue)ScriptBytecodeAdapter.castToType((Object)object4, BlockingQueue.class);
        callSiteArray[15].call((Object)this.eventManager, (Object)this);
    }

    @Override
    protected void doDestroy() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.changelogConnection)) {
            callSiteArray[16].call((Object)this.changelogConnection);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.processingThreads)) {
            callSiteArray[17].call((Object)this.processingThreads);
        }
        callSiteArray[18].call((Object)this.eventManager, (Object)this);
    }

    @Override
    protected void doRun() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        try {
            boolean bl = true;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
            long timestamp = DefaultTypeTransformation.longUnbox((Object)callSiteArray[19].call(System.class));
            while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[20].callCurrent((GroovyObject)this))) {
                long count = DefaultTypeTransformation.longUnbox((Object)callSiteArray[21].callCurrent((GroovyObject)this));
                long now = DefaultTypeTransformation.longUnbox((Object)callSiteArray[22].call(System.class));
                if (count > 0L) {
                    long l;
                    timestamp = l = now;
                }
                callSiteArray[23].call(callSiteArray[24].callGroovyObjectGetProperty((Object)this), (Object)"Waiting for more changes");
                Object elapsed = callSiteArray[25].callCurrent((GroovyObject)this, callSiteArray[26].call(TimeCategory.class, callSiteArray[27].callConstructor(Date.class, (Object)now), callSiteArray[28].callConstructor(Date.class, (Object)timestamp)));
                GStringImpl gStringImpl = new GStringImpl(new Object[]{this.totalCount, callSiteArray[29].callCurrent((GroovyObject)this), elapsed}, new String[]{"", " processed ", ", ", " since last change, press \"Continue\" when ready"});
                ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl), ProcessChangesStep.class, (GroovyObject)this, (String)"status");
                callSiteArray[30].call((Object)ADDITIONAL_CHANGES_CHECK_DELAY);
            }
        }
        finally {
            boolean bl = false;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
        }
    }

    @Override
    protected void doAbort() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        boolean bl = false;
        ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
    }

    public String simplify(TimeDuration duration) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        String days = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[31].callGetProperty((Object)duration), (Object)1) ? "1 day" : new GStringImpl(new Object[]{callSiteArray[32].callGetProperty((Object)duration)}, new String[]{"", " days"});
        String hours = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[33].callGetProperty((Object)duration), (Object)1) ? "1 hour" : new GStringImpl(new Object[]{callSiteArray[34].callGetProperty((Object)duration)}, new String[]{"", " hours"});
        String minutes = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[35].callGetProperty((Object)duration), (Object)1) ? "1 minute" : new GStringImpl(new Object[]{callSiteArray[36].callGetProperty((Object)duration)}, new String[]{"", " minutes"});
        String seconds = ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[37].callGetProperty((Object)duration), (Object)1) ? "1 second" : new GStringImpl(new Object[]{callSiteArray[38].callGetProperty((Object)duration)}, new String[]{"", " seconds"});
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[39].callGetProperty((Object)duration), (Object)0)) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{days, hours}, new String[]{"", " ", ""}));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[40].callGetProperty((Object)duration), (Object)0)) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{hours, minutes}, new String[]{"", " ", ""}));
        }
        if (ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[41].callGetProperty((Object)duration), (Object)0)) {
            return ShortTypeHandling.castToString((Object)minutes);
        }
        return ShortTypeHandling.castToString((Object)seconds);
    }

    private boolean shouldRun() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[42].callGroovyObjectGetProperty((Object)this)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[43].call((Object)this.stopWaiting));
        }
        return !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[44].callGroovyObjectGetProperty((Object)this)) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[45].call((Object)this.stopWaiting));
    }

    public boolean isWaiting() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[46].call((Object)this.waitingForChanges));
    }

    public boolean stopWaiting() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[47].call((Object)this.waitingForChanges))) {
            callSiteArray[48].call((Object)this.stopWaiting, (Object)true);
            return true;
        }
        return false;
    }

    public long sync() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Set pathsInUse = (Set)ScriptBytecodeAdapter.castToType((Object)callSiteArray[49].callConstructor(HashSet.class), Set.class);
        Reference lastProcessedChangeId = new Reference(this.lastProcessedChangeId);
        callSiteArray[50].call(this.completionOrder, (Object)new GeneratedClosure((Object)this, (Object)this, lastProcessedChangeId){
            private /* synthetic */ Reference lastProcessedChangeId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _sync_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.lastProcessedChangeId = reference = lastProcessedChangeId;
            }

            public Object doCall(Object completedId) {
                CallSite[] callSiteArray = _sync_closure1.$getCallSiteArray();
                return callSiteArray[0].call(this.lastProcessedChangeId.get(), completedId);
            }

            public Object getLastProcessedChangeId() {
                CallSite[] callSiteArray = _sync_closure1.$getCallSiteArray();
                return this.lastProcessedChangeId.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _sync_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "set";
                return new CallSiteArray(_sync_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _sync_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        int count = 0;
        Object iterator = callSiteArray[51].call(callSiteArray[52].callCurrent((GroovyObject)this, callSiteArray[53].call(lastProcessedChangeId.get())));
        PeekingIterator changes = (PeekingIterator)ScriptBytecodeAdapter.castToType((Object)callSiteArray[54].call(Iterators.class, iterator), PeekingIterator.class);
        boolean pathContention = false;
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[55].call((Object)changes))) {
            callSiteArray[56].call((Object)this.waitingForChanges, (Object)false);
        }
        while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[57].call((Object)changes)) || !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call((Object)pathsInUse))) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.totalCount, callSiteArray[59].callCurrent((GroovyObject)this)}, new String[]{"Processed ", " items ", "..."});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl), ProcessChangesStep.class, (GroovyObject)this, (String)"status");
            while (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[60].call((Object)changes)) && !pathContention && ScriptBytecodeAdapter.compareLessThan((Object)callSiteArray[61].call((Object)pathsInUse), (Object)this.threadCount)) {
                Object nextChange = callSiteArray[62].call((Object)changes);
                Object path = callSiteArray[63].callCurrent((GroovyObject)this, nextChange);
                if (ScriptBytecodeAdapter.isCase((Object)path, (Object)pathsInUse)) {
                    boolean bl;
                    pathContention = bl = true;
                    continue;
                }
                callSiteArray[64].call((Object)pathsInUse, path);
                callSiteArray[65].callCurrent((GroovyObject)this, nextChange);
                callSiteArray[66].call((Object)changes);
                int n = this.totalCount;
                this.totalCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[67].call((Object)n));
            }
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[68].call((Object)pathsInUse))) {
                Object result = callSiteArray[69].call(this.results);
                Object resultPath = callSiteArray[70].callCurrent((GroovyObject)this, callSiteArray[71].callGetProperty(result));
                callSiteArray[72].call((Object)pathsInUse, resultPath);
                Object nextChange = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[73].call((Object)changes)) ? callSiteArray[74].call((Object)changes) : null;
                if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[75].callCurrent((GroovyObject)this, nextChange), (Object)resultPath)) {
                    boolean bl;
                    pathContention = bl = false;
                }
                int n = count;
                count = DefaultTypeTransformation.intUnbox((Object)callSiteArray[76].call((Object)n));
                if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[77].callGetProperty(result))) {
                    String repositoryId = ShortTypeHandling.castToString((Object)callSiteArray[78].callGetProperty(callSiteArray[79].callGetProperty(result)));
                    Object changeType = callSiteArray[80].callGetProperty(callSiteArray[81].callGetProperty(callSiteArray[82].callGetProperty(result)));
                    Object e = callSiteArray[83].callGetProperty(result);
                    callSiteArray[84].call(callSiteArray[85].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Failed processing of %s %s:%s.  %s", (Object)changeType, (Object)repositoryId, (Object)resultPath, (Object)callSiteArray[86].callGetProperty(e)));
                    if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[87].call(callSiteArray[88].callGroovyObjectGetProperty((Object)this)))) {
                        callSiteArray[89].call(callSiteArray[90].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Failed processing of {} {}:{}, will ignore and move on. {}", (Object)changeType, (Object)repositoryId, (Object)resultPath, (Object)callSiteArray[91].callGetProperty(e), (Object)e));
                    } else {
                        callSiteArray[92].call(callSiteArray[93].callGroovyObjectGetProperty((Object)this), ArrayUtil.createArray((Object)"Failed processing of {} {}:{}, will ignore and move on. {}", (Object)changeType, (Object)repositoryId, (Object)resultPath, (Object)callSiteArray[94].callGetProperty(e)));
                    }
                    int n2 = this.failedCount;
                    this.failedCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[95].call((Object)n2));
                }
            }
            GStringImpl gStringImpl2 = new GStringImpl(new Object[]{this.totalCount, callSiteArray[96].callCurrent((GroovyObject)this)}, new String[]{"Processed ", " items ", "..."});
            ScriptBytecodeAdapter.setGroovyObjectProperty((Object)ShortTypeHandling.castToString((Object)gStringImpl2), ProcessChangesStep.class, (GroovyObject)this, (String)"status");
        }
        callSiteArray[97].call((Object)this.waitingForChanges, (Object)true);
        return count;
    }

    @Nullable
    private String calculatePath(@Nullable RepositoryChangelogClient.ChangeEntryXO change) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)change)) {
            return ShortTypeHandling.castToString(null);
        }
        Object migrator = callSiteArray[98].call((Object)this.repositoryMigrationManager, callSiteArray[99].callGetProperty((Object)change));
        if (!DefaultTypeTransformation.booleanUnbox((Object)migrator)) {
            return ShortTypeHandling.castToString((Object)callSiteArray[100].callGetProperty(callSiteArray[101].callGetProperty((Object)change)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[102].call(migrator, (Object)change));
    }

    private String failedText() {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        if (this.failedCount != 0) {
            return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.failedCount}, new String[]{" <a href=\"#\" onclick=\"return false;\">(", " failed)</a>"}));
        }
        return "";
    }

    private void submit(RepositoryChangelogClient.ChangeEntryXO change) {
        Reference change2 = new Reference((Object)change);
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        callSiteArray[103].call(this.completionOrder, callSiteArray[104].callGetProperty((Object)((RepositoryChangelogClient.ChangeEntryXO)change2.get())));
        Reference resultQueue = new Reference(this.results);
        Reference order = new Reference(this.completionOrder);
        callSiteArray[105].call((Object)this.processingThreads, (Object)new GeneratedClosure((Object)this, (Object)this, resultQueue, change2, order){
            private /* synthetic */ Reference resultQueue;
            private /* synthetic */ Reference change;
            private /* synthetic */ Reference order;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                Reference reference2;
                Reference reference3;
                CallSite[] callSiteArray = _submit_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.resultQueue = reference3 = resultQueue;
                this.change = reference2 = change;
                this.order = reference = order;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _submit_closure2.$getCallSiteArray();
                callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), (Object)"Processing change {}", this.change.get());
                Object migrator = callSiteArray[2].call(callSiteArray[3].callGroovyObjectGetProperty(this.getThisObject()), callSiteArray[4].callGetProperty(this.change.get()));
                callSiteArray[5].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)migrator, null), (Object)"No migrator found for repository %s", callSiteArray[6].callGetProperty(this.change.get()));
                callSiteArray[7].call(migrator, this.change.get());
                callSiteArray[8].call(this.resultQueue.get(), callSiteArray[9].callConstructor(ProcessingResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"change", this.change.get()})));
                Object object = callSiteArray[10].call(this.order.get(), callSiteArray[11].callGetProperty(this.change.get()));
                try {
                    return object;
                }
                catch (Exception e) {
                    callSiteArray[12].call(this.resultQueue.get(), callSiteArray[13].callConstructor(ProcessingResult.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"change", this.change.get(), "exception", e})));
                    Object object2 = callSiteArray[14].call(this.order.get(), callSiteArray[15].callGetProperty(this.change.get()));
                    return object2;
                }
            }

            public BlockingQueue getResultQueue() {
                CallSite[] callSiteArray = _submit_closure2.$getCallSiteArray();
                return (BlockingQueue)ScriptBytecodeAdapter.castToType((Object)this.resultQueue.get(), BlockingQueue.class);
            }

            public RepositoryChangelogClient.ChangeEntryXO getChange() {
                CallSite[] callSiteArray = _submit_closure2.$getCallSiteArray();
                return (RepositoryChangelogClient.ChangeEntryXO)ScriptBytecodeAdapter.castToType((Object)this.change.get(), RepositoryChangelogClient.ChangeEntryXO.class);
            }

            public CompletionOrderHelper getOrder() {
                CallSite[] callSiteArray = _submit_closure2.$getCallSiteArray();
                return (CompletionOrderHelper)ScriptBytecodeAdapter.castToType((Object)this.order.get(), CompletionOrderHelper.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _submit_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _submit_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "trace";
                stringArray[1] = "log";
                stringArray[2] = "findMigrator";
                stringArray[3] = "repositoryMigrationManager";
                stringArray[4] = "repositoryId";
                stringArray[5] = "checkState";
                stringArray[6] = "repositoryId";
                stringArray[7] = "processChange";
                stringArray[8] = "put";
                stringArray[9] = "<$constructor$>";
                stringArray[10] = "complete";
                stringArray[11] = "id";
                stringArray[12] = "put";
                stringArray[13] = "<$constructor$>";
                stringArray[14] = "abort";
                stringArray[15] = "id";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[16];
                _submit_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_submit_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _submit_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
    }

    public Iterable<RepositoryChangelogClient.ChangeEntryXO> after(String afterChangeEntryId) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Reference nextFetchId = new Reference((Object)afterChangeEntryId);
        return (Iterable)ScriptBytecodeAdapter.castToType((Object)new GeneratedClosure((Object)this, (Object)this, nextFetchId){
            private /* synthetic */ Reference nextFetchId;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _after_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.nextFetchId = reference = nextFetchId;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _after_closure3.$getCallSiteArray();
                return callSiteArray[0].callConstructor(BufferingIterator.class, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Supplier)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure((Object)this, this.getThisObject(), this.nextFetchId){
                    private /* synthetic */ Reference nextFetchId;
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        Reference reference;
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                        this.nextFetchId = reference = nextFetchId;
                    }

                    public Object doCall(Object it) {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        Object changes = callSiteArray[0].call(callSiteArray[1].callGroovyObjectGetProperty((Object)this), this.nextFetchId.get(), callSiteArray[2].callGroovyObjectGetProperty((Object)this));
                        if (DefaultTypeTransformation.booleanUnbox((Object)changes)) {
                            RepositoryChangelogClient.ChangeEntryXO last = (RepositoryChangelogClient.ChangeEntryXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].call(Iterables.class, changes), RepositoryChangelogClient.ChangeEntryXO.class);
                            Object object = callSiteArray[4].call((Object)last);
                            this.nextFetchId.set(object);
                        }
                        return changes;
                    }

                    public Object getNextFetchId() {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        return this.nextFetchId.get();
                    }

                    public Object doCall() {
                        CallSite[] callSiteArray = _closure4.$getCallSiteArray();
                        return this.doCall(null);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _closure4.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                        stringArray[0] = "get";
                        stringArray[1] = "changelogConnection";
                        stringArray[2] = "CHANGELOG_FETCH_SIZE";
                        stringArray[3] = "getLast";
                        stringArray[4] = "getId";
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[5];
                        _closure4.$createCallSiteArray_1(stringArray);
                        return new CallSiteArray(_closure4.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _closure4.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }, Supplier.class)), Supplier.class));
            }

            public Object getNextFetchId() {
                CallSite[] callSiteArray = _after_closure3.$getCallSiteArray();
                return this.nextFetchId.get();
            }

            public Object doCall() {
                CallSite[] callSiteArray = _after_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _after_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "<$constructor$>";
                return new CallSiteArray(_after_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _after_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }, Iterable.class);
    }

    @Subscribe
    public void on(MigrationReconnectionEvent event) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        String string = "HTTP connection restored";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, ProcessChangesStep.class, (GroovyObject)this, (String)"status");
        callSiteArray[106].call(callSiteArray[107].callGroovyObjectGetProperty((Object)this), (Object)"HTTP connection restored");
    }

    @Subscribe
    public void on(MigrationDisconnectionEvent event) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        GStringImpl message = new GStringImpl(new Object[]{callSiteArray[108].callGetProperty((Object)event), callSiteArray[109].callGetProperty((Object)event)}, new String[]{"HTTP disconnection: ", ", retrying at ", ""});
        GStringImpl gStringImpl = message;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, ProcessChangesStep.class, (GroovyObject)this, (String)"status");
        callSiteArray[110].call(callSiteArray[111].callGroovyObjectGetProperty((Object)this), (Object)message);
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProcessChangesStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProcessChangesStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        CallSite[] callSiteArray = ProcessChangesStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProcessChangesStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != ProcessChangesStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Object object = ProcessChangesStep.$getCallSiteArray()[112].call(ProcessChangesStep.$getCallSiteArray()[113].call(Runtime.class));
        DEFAULT_PROCESSING_THREADS = DefaultTypeTransformation.intUnbox((Object)object);
        Object object2 = ProcessChangesStep.$getCallSiteArray()[114].call(Time.class, (Object)15);
        ADDITIONAL_CHANGES_CHECK_DELAY = (Time)ScriptBytecodeAdapter.castToType((Object)object2, Time.class);
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    public RepositoryMigrationManager getRepositoryMigrationManager() {
        return this.repositoryMigrationManager;
    }

    public void setRepositoryMigrationManager(RepositoryMigrationManager repositoryMigrationManager) {
        this.repositoryMigrationManager = repositoryMigrationManager;
    }

    public RepositoryChangelogClient getRepositoryChangelogClient() {
        return this.repositoryChangelogClient;
    }

    public void setRepositoryChangelogClient(RepositoryChangelogClient repositoryChangelogClient) {
        this.repositoryChangelogClient = repositoryChangelogClient;
    }

    public RequestMonitorController getHttpController() {
        return this.httpController;
    }

    public void setHttpController(RequestMonitorController requestMonitorController) {
        this.httpController = requestMonitorController;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public void setEventManager(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public /* synthetic */ void super$3$doInit() {
        super.doInit();
    }

    public /* synthetic */ MetaClass super$3$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$doConfigure(Map map) {
        super.doConfigure(map);
    }

    public /* synthetic */ void super$3$doAbort() {
        super.doAbort();
    }

    public /* synthetic */ void super$3$doDestroy() {
        super.doDestroy();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "SYNC";
        stringArray[5] = "assistant";
        stringArray[6] = "get";
        stringArray[7] = "getInteger";
        stringArray[8] = "plus";
        stringArray[9] = "name";
        stringArray[10] = "info";
        stringArray[11] = "log";
        stringArray[12] = "newFixedThreadPool";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "register";
        stringArray[16] = "close";
        stringArray[17] = "shutdownNow";
        stringArray[18] = "unregister";
        stringArray[19] = "currentTimeMillis";
        stringArray[20] = "shouldRun";
        stringArray[21] = "sync";
        stringArray[22] = "currentTimeMillis";
        stringArray[23] = "debug";
        stringArray[24] = "log";
        stringArray[25] = "simplify";
        stringArray[26] = "minus";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "failedText";
        stringArray[30] = "sleep";
        stringArray[31] = "days";
        stringArray[32] = "days";
        stringArray[33] = "hours";
        stringArray[34] = "hours";
        stringArray[35] = "minutes";
        stringArray[36] = "minutes";
        stringArray[37] = "seconds";
        stringArray[38] = "seconds";
        stringArray[39] = "days";
        stringArray[40] = "hours";
        stringArray[41] = "minutes";
        stringArray[42] = "aborted";
        stringArray[43] = "get";
        stringArray[44] = "aborted";
        stringArray[45] = "get";
        stringArray[46] = "get";
        stringArray[47] = "get";
        stringArray[48] = "set";
        stringArray[49] = "<$constructor$>";
        stringArray[50] = "onOrderedCompletion";
        stringArray[51] = "iterator";
        stringArray[52] = "after";
        stringArray[53] = "get";
        stringArray[54] = "peekingIterator";
        stringArray[55] = "hasNext";
        stringArray[56] = "set";
        stringArray[57] = "hasNext";
        stringArray[58] = "isEmpty";
        stringArray[59] = "failedText";
        stringArray[60] = "hasNext";
        stringArray[61] = "size";
        stringArray[62] = "peek";
        stringArray[63] = "calculatePath";
        stringArray[64] = "add";
        stringArray[65] = "submit";
        stringArray[66] = "next";
        stringArray[67] = "next";
        stringArray[68] = "isEmpty";
        stringArray[69] = "take";
        stringArray[70] = "calculatePath";
        stringArray[71] = "change";
        stringArray[72] = "remove";
        stringArray[73] = "hasNext";
        stringArray[74] = "peek";
        stringArray[75] = "calculatePath";
        stringArray[76] = "next";
        stringArray[77] = "successful";
        stringArray[78] = "repositoryId";
        stringArray[79] = "change";
        stringArray[80] = "type";
        stringArray[81] = "change";
        stringArray[82] = "change";
        stringArray[83] = "exception";
        stringArray[84] = "add";
        stringArray[85] = "progressLog";
        stringArray[86] = "message";
        stringArray[87] = "isDebugEnabled";
        stringArray[88] = "log";
        stringArray[89] = "error";
        stringArray[90] = "log";
        stringArray[91] = "message";
        stringArray[92] = "error";
        stringArray[93] = "log";
        stringArray[94] = "message";
        stringArray[95] = "next";
        stringArray[96] = "failedText";
        stringArray[97] = "set";
        stringArray[98] = "findMigrator";
        stringArray[99] = "repositoryId";
        stringArray[100] = "path";
        stringArray[101] = "change";
        stringArray[102] = "calculatePath";
        stringArray[103] = "start";
        stringArray[104] = "id";
        stringArray[105] = "submit";
        stringArray[106] = "add";
        stringArray[107] = "progressLog";
        stringArray[108] = "disconnectDescription";
        stringArray[109] = "delayUntil";
        stringArray[110] = "add";
        stringArray[111] = "progressLog";
        stringArray[112] = "availableProcessors";
        stringArray[113] = "getRuntime";
        stringArray[114] = "seconds";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[115];
        ProcessChangesStep.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProcessChangesStep.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProcessChangesStep.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    public static class ProcessingResult
    implements GroovyObject {
        private RepositoryChangelogClient.ChangeEntryXO change;
        private Exception exception;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        public ProcessingResult() {
            MetaClass metaClass;
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean isSuccessful() {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return !DefaultTypeTransformation.booleanUnbox((Object)this.exception);
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(ProcessingResult.class, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = ProcessingResult.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(ProcessingResult.class, ProcessChangesStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ProcessingResult.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public RepositoryChangelogClient.ChangeEntryXO getChange() {
            return this.change;
        }

        public void setChange(RepositoryChangelogClient.ChangeEntryXO changeEntryXO) {
            this.change = changeEntryXO;
        }

        public Exception getException() {
            return this.exception;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(ProcessingResult.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = ProcessingResult.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

