/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationPhases;
import com.sonatype.nexus.migration.client.RepositoryMigrationClient;
import com.sonatype.nexus.migration.repository.RepositoryScanStatus;
import com.sonatype.nexus.migration.repository.RepositoryStepSupport;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.sonatype.goodies.common.Time;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="migration.repositories-scan")
public class RepositoriesScanStep
extends RepositoryStepSupport {
    @Inject
    private RepositoryMigrationClient repositoryMigrationClient;
    @Inject
    private MigrationService migrationService;
    private int scannedRepositoriesCount;
    private Set<String> repositoriesToScan;
    public static final String TYPE_NAME = "migration.repositories-scan";
    private Time DELAY;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RepositoriesScanStep() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(HashSet.class);
        this.repositoriesToScan = (Set)ScriptBytecodeAdapter.castToType((Object)object, Set.class);
        Object object2 = callSiteArray[1].call(Time.class, (Object)15);
        this.DELAY = (Time)ScriptBytecodeAdapter.castToType((Object)object2, Time.class);
    }

    @Override
    public String getType() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        return TYPE_NAME;
    }

    @Override
    protected void doInit() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        callSiteArray[2].call(this.repositoriesToScan, callSiteArray[3].callGroovyObjectGetProperty((Object)this));
    }

    @Override
    protected void doConfigure(Map<String, Object> config) {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        Object object = callSiteArray[4].callGetProperty(MigrationPhases.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoriesScanStep.class, (GroovyObject)this, (String)"phase");
        Object object2 = callSiteArray[5].callGetProperty(config);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, RepositoriesScanStep.class, (GroovyObject)this, (String)"selectedRepositories");
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[6].call(callSiteArray[7].callGetProperty(config))}, new String[]{"Scan ", " repositories"});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, RepositoriesScanStep.class, (GroovyObject)this, (String)"name");
    }

    @Override
    protected void doRun() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[8].callCurrent((GroovyObject)this);
            while (DefaultTypeTransformation.booleanUnbox(this.repositoriesToScan) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[9].callCurrent((GroovyObject)this))) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[10].call(this.repositoriesToScan, (Object)new GeneratedClosure((Object)this, (Object)this){
                    private static /* synthetic */ ClassInfo $staticClassInfo;
                    public static transient /* synthetic */ boolean __$stMC;
                    private static /* synthetic */ SoftReference $callSiteArray;
                    {
                        CallSite[] callSiteArray = _doRun_closure1.$getCallSiteArray();
                        super(_outerInstance, _thisObject);
                    }

                    public Object doCall(Object repository) {
                        CallSite[] callSiteArray = _doRun_closure1.$getCallSiteArray();
                        return callSiteArray[0].callCurrent((GroovyObject)this, repository);
                    }

                    protected /* synthetic */ MetaClass $getStaticMetaClass() {
                        if (((Object)((Object)this)).getClass() != _doRun_closure1.class) {
                            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                        }
                        ClassInfo classInfo = $staticClassInfo;
                        if (classInfo == null) {
                            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                        }
                        return classInfo.getMetaClass();
                    }

                    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                        String[] stringArray = new String[1];
                        stringArray[0] = "checkRepositoryStatus";
                        return new CallSiteArray(_doRun_closure1.class, stringArray);
                    }

                    private static /* synthetic */ CallSite[] $getCallSiteArray() {
                        CallSiteArray callSiteArray;
                        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                            callSiteArray = _doRun_closure1.$createCallSiteArray();
                            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                        }
                        return callSiteArray.array;
                    }
                }))) {
                    callSiteArray[11].callCurrent((GroovyObject)this);
                }
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[12].call(this.repositoriesToScan), (Object)0) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].callCurrent((GroovyObject)this)))) continue;
                callSiteArray[14].call((Object)this.DELAY);
            }
        } else {
            this.updateStatus();
            while (DefaultTypeTransformation.booleanUnbox(this.repositoriesToScan) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[15].callCurrent((GroovyObject)this))) {
                if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].call(this.repositoriesToScan, (Object)new /* invalid duplicate definition of identical inner class */))) {
                    this.updateStatus();
                }
                if (!(ScriptBytecodeAdapter.compareGreaterThan((Object)callSiteArray[17].call(this.repositoriesToScan), (Object)0) && !DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[18].callCurrent((GroovyObject)this)))) continue;
                callSiteArray[19].call((Object)this.DELAY);
            }
        }
    }

    private void updateStatus() {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        GStringImpl status = new GStringImpl(new Object[]{this.scannedRepositoriesCount, callSiteArray[20].call(callSiteArray[21].callGroovyObjectGetProperty((Object)this))}, new String[]{"Scanned ", " of ", " repositories"});
        callSiteArray[22].callCurrent((GroovyObject)this, (Object)status);
        callSiteArray[23].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)Float.valueOf(DefaultTypeTransformation.floatUnbox((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[24].call((Object)this.scannedRepositoriesCount, callSiteArray[25].call(callSiteArray[26].callGroovyObjectGetProperty((Object)this))), Float.TYPE))), Float.TYPE));
        callSiteArray[27].call(callSiteArray[28].callGroovyObjectGetProperty((Object)this), (Object)"{}, remaining repositories: {}", (Object)status, this.repositoriesToScan);
    }

    private boolean checkRepositoryStatus(String repository) {
        CallSite[] callSiteArray = RepositoriesScanStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].callCurrent((GroovyObject)this))) {
            return false;
        }
        Object repositoryMigrationStatus = callSiteArray[30].call((Object)this.repositoryMigrationClient, callSiteArray[31].callGetProperty((Object)this.migrationService), (Object)repository);
        callSiteArray[32].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)repositoryMigrationStatus, null), (Object)"Failed to fetch repository status from remote agent");
        Object scanStatus = callSiteArray[33].call(Enums.class, RepositoryScanStatus.class, callSiteArray[34].callGetProperty(repositoryMigrationStatus));
        callSiteArray[35].callStatic(Preconditions.class, callSiteArray[36].callGetProperty(scanStatus), (Object)new GStringImpl(new Object[]{callSiteArray[37].callGetProperty(repositoryMigrationStatus)}, new String[]{"Unexpected status ", ""}));
        Object scanStatusCode = callSiteArray[38].call(scanStatus);
        callSiteArray[39].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)scanStatusCode, (Object)callSiteArray[40].callGetProperty(RepositoryScanStatus.class)), (Object)"Scan cancelled");
        callSiteArray[41].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)scanStatusCode, (Object)callSiteArray[42].callGetProperty(RepositoryScanStatus.class)), (Object)"Scan failed");
        if (ScriptBytecodeAdapter.compareEqual((Object)scanStatusCode, (Object)callSiteArray[43].callGetProperty(RepositoryScanStatus.class))) {
            int n = this.scannedRepositoriesCount;
            this.scannedRepositoriesCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[44].call((Object)n));
            return true;
        }
        return false;
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RepositoriesScanStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public RepositoryMigrationClient getRepositoryMigrationClient() {
        return this.repositoryMigrationClient;
    }

    public void setRepositoryMigrationClient(RepositoryMigrationClient repositoryMigrationClient) {
        this.repositoryMigrationClient = repositoryMigrationClient;
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    public int getScannedRepositoriesCount() {
        return this.scannedRepositoriesCount;
    }

    public void setScannedRepositoriesCount(int n) {
        this.scannedRepositoriesCount = n;
    }

    public Set<String> getRepositoriesToScan() {
        return this.repositoriesToScan;
    }

    public void setRepositoriesToScan(Set<String> set) {
        this.repositoriesToScan = set;
    }

    public Time getDELAY() {
        return this.DELAY;
    }

    public void setDELAY(Time time) {
        this.DELAY = time;
    }

    public /* synthetic */ void super$3$doInit() {
        super.doInit();
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$doConfigure(Map map) {
        super.doConfigure(map);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "seconds";
        stringArray[2] = "addAll";
        stringArray[3] = "selectedRepositories";
        stringArray[4] = "SYNC";
        stringArray[5] = "selectedRepositories";
        stringArray[6] = "size";
        stringArray[7] = "selectedRepositories";
        stringArray[8] = "updateStatus";
        stringArray[9] = "isAborted";
        stringArray[10] = "removeAll";
        stringArray[11] = "updateStatus";
        stringArray[12] = "size";
        stringArray[13] = "isAborted";
        stringArray[14] = "sleep";
        stringArray[15] = "isAborted";
        stringArray[16] = "removeAll";
        stringArray[17] = "size";
        stringArray[18] = "isAborted";
        stringArray[19] = "sleep";
        stringArray[20] = "size";
        stringArray[21] = "selectedRepositories";
        stringArray[22] = "setStatus";
        stringArray[23] = "setComplete";
        stringArray[24] = "div";
        stringArray[25] = "size";
        stringArray[26] = "selectedRepositories";
        stringArray[27] = "debug";
        stringArray[28] = "log";
        stringArray[29] = "isAborted";
        stringArray[30] = "status";
        stringArray[31] = "assistant";
        stringArray[32] = "checkState";
        stringArray[33] = "getIfPresent";
        stringArray[34] = "scanStatus";
        stringArray[35] = "checkState";
        stringArray[36] = "present";
        stringArray[37] = "scanStatus";
        stringArray[38] = "get";
        stringArray[39] = "checkState";
        stringArray[40] = "CANCELLED";
        stringArray[41] = "checkState";
        stringArray[42] = "FAILED";
        stringArray[43] = "FINISHED";
        stringArray[44] = "next";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[45];
        RepositoriesScanStep.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RepositoriesScanStep.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RepositoriesScanStep.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

