/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationPhases;
import com.sonatype.nexus.migration.client.RepositoryClient;
import com.sonatype.nexus.migration.client.RepositoryMigrationClient;
import com.sonatype.nexus.migration.client.http.RequestMonitorController;
import com.sonatype.nexus.migration.firewall.FirewallMigrationFacade;
import com.sonatype.nexus.migration.plan.Step;
import com.sonatype.nexus.migration.plan.StepContext;
import com.sonatype.nexus.migration.repository.ChangelogPurgeStep;
import com.sonatype.nexus.migration.repository.RepositoriesCloneHistoryStep;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import com.sonatype.nexus.migration.repository.RepositoryPrepareStep;
import com.sonatype.nexus.migration.repository.RepositoryStepSupport;
import com.sonatype.nexus.plugins.healthcheck.service.ConfigService;
import com.sonatype.nexus.plugins.healthcheck.service.HealthCheckTaskManager;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.search.SearchFacet;
import org.sonatype.nexus.repository.storage.StorageFacetConstants;
import org.sonatype.nexus.upgrade.plan.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="migration.repository-finish")
public class RepositoryFinishStep
extends RepositoryStepSupport {
    public static final String TYPE_NAME = "migration.repository-finish";
    @Inject
    private MigrationService migrationService;
    @Inject
    private RepositoryMigrationManager repositoryMigrationManager;
    @Inject
    private RepositoryClient repositoryClient;
    @Inject
    private RepositoryMigrationClient repositoryMigrationClient;
    @Inject
    private RequestMonitorController httpController;
    @Inject
    private ConfigService configService;
    @Inject
    private HealthCheckTaskManager taskManager;
    @Inject
    private FirewallMigrationFacade firewallMigrationFacade;
    private boolean iqMigrationEnabled;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RepositoryFinishStep() {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
    }

    @Override
    public String getType() {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        return TYPE_NAME;
    }

    @Override
    protected void doConfigure(Map<String, Object> config) {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(MigrationPhases.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoryFinishStep.class, (GroovyObject)this, (String)"phase");
        String string = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[1].callGetProperty(config), String.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, RepositoryFinishStep.class, (GroovyObject)this, (String)"repositoryName");
        Object object2 = callSiteArray[2].callGetProperty(config);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, RepositoryFinishStep.class, (GroovyObject)this, (String)"selectedRepositories");
        Object object3 = callSiteArray[3].callGetProperty(config);
        this.iqMigrationEnabled = DefaultTypeTransformation.booleanUnbox((Object)object3);
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[4].callGroovyObjectGetProperty((Object)this)}, new String[]{"Finish upgrading repository: ", ""});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, RepositoryFinishStep.class, (GroovyObject)this, (String)"name");
    }

    @Override
    protected void doInit() {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        Object object = callSiteArray[5].call((Object)this.repositoryClient, callSiteArray[6].callGetProperty((Object)this.migrationService), callSiteArray[7].callGroovyObjectGetProperty((Object)this));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((RepositoryClient.RepositoryDetailXO)ScriptBytecodeAdapter.castToType((Object)object, RepositoryClient.RepositoryDetailXO.class)), RepositoryFinishStep.class, (GroovyObject)this, (String)"repositoryDetail");
        callSiteArray[8].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[9].callGroovyObjectGetProperty((Object)this), null), (Object)"Failed to fetch repository details from remote agent");
        callSiteArray[10].call(callSiteArray[11].callGroovyObjectGetProperty((Object)this), callSiteArray[12].callStatic(ChangelogPurgeStep.class));
        if (this.iqMigrationEnabled) {
            callSiteArray[13].call(callSiteArray[14].callGroovyObjectGetProperty((Object)this), callSiteArray[15].callStatic(RepositoriesCloneHistoryStep.class));
        }
        callSiteArray[16].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.getMethodPointer((Object)((Object)this), (String)"finished"));
    }

    @Override
    protected void doRun() {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[17].callGroovyObjectGetProperty((Object)this))) {
            GStringImpl msg = new GStringImpl(new Object[]{callSiteArray[18].callGroovyObjectGetProperty((Object)this)}, new String[]{"Group repository would be empty and has not been created: ", ""});
            callSiteArray[19].call(callSiteArray[20].callGroovyObjectGetProperty((Object)this), (Object)msg);
            callSiteArray[21].call(callSiteArray[22].callGetProperty(StepContext.class), (Object)msg);
        } else {
            Object assistant = callSiteArray[23].callGetProperty((Object)this.migrationService);
            try {
                boolean bl = true;
                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
                callSiteArray[24].call((Object)this.repositoryMigrationClient, assistant, callSiteArray[25].callGroovyObjectGetProperty((Object)this));
            }
            finally {
                boolean bl = false;
                ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)this.httpController, (String)"indefiniteRetry");
            }
            callSiteArray[26].call((Object)this.repositoryMigrationManager, callSiteArray[27].callGroovyObjectGetProperty((Object)this));
            Object repository = callSiteArray[28].call(callSiteArray[29].callGroovyObjectGetProperty((Object)this), callSiteArray[30].callGroovyObjectGetProperty((Object)this));
            Object config = callSiteArray[31].callGetProperty(repository);
            boolean bl = true;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)config, (String)"online");
            callSiteArray[32].call(callSiteArray[33].callGroovyObjectGetProperty((Object)this), config);
            callSiteArray[34].callCurrent((GroovyObject)this, repository);
            callSiteArray[35].callCurrent((GroovyObject)this, repository);
            callSiteArray[36].call((Object)this.firewallMigrationFacade, repository);
            callSiteArray[37].call(callSiteArray[38].call(repository, SearchFacet.class), (Object)new GeneratedClosure((Object)this, (Object)this){
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    CallSite[] callSiteArray = _doRun_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object facet) {
                    CallSite[] callSiteArray = _doRun_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(facet);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _doRun_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[1];
                    stringArray[0] = "rebuildIndex";
                    return new CallSiteArray(_doRun_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _doRun_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
        }
    }

    @Override
    protected void doAbort() {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        callSiteArray[39].call((Object)this.repositoryMigrationManager, callSiteArray[40].callGroovyObjectGetProperty((Object)this));
    }

    private void finalizeWritePolicy(Repository repository) {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        Object migration = callSiteArray[41].call(callSiteArray[42].callGetProperty(callSiteArray[43].call((Object)repository, AttributesFacet.class)), callSiteArray[44].callGetProperty(RepositoryPrepareStep.class));
        Object config = callSiteArray[45].callGetProperty((Object)repository);
        callSiteArray[46].call(callSiteArray[47].call(config, callSiteArray[48].callGetProperty(StorageFacetConstants.class)), callSiteArray[49].callGetProperty(StorageFacetConstants.class), callSiteArray[50].call(migration, callSiteArray[51].callGetProperty(StorageFacetConstants.class)));
        callSiteArray[52].call(callSiteArray[53].callGroovyObjectGetProperty((Object)this), config);
    }

    private void maybeConfigureRepositoryHealthCheck(Repository repository) {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        Object migration = callSiteArray[54].call(callSiteArray[55].callGetProperty(callSiteArray[56].call((Object)repository, AttributesFacet.class)), callSiteArray[57].callGetProperty(RepositoryPrepareStep.class));
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[58].call(migration, callSiteArray[59].callGetProperty(RepositoryPrepareStep.class)))) {
            Boolean enabled = (Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[60].call(migration, callSiteArray[61].callGetProperty(RepositoryPrepareStep.class)), Boolean.class);
            callSiteArray[62].call((Object)this.configService, callSiteArray[63].callGroovyObjectGetProperty((Object)this), (Object)enabled);
            if (DefaultTypeTransformation.booleanUnbox((Object)enabled)) {
                callSiteArray[64].call((Object)this.taskManager, callSiteArray[65].callGroovyObjectGetProperty((Object)this));
            } else {
                callSiteArray[66].call((Object)this.taskManager, callSiteArray[67].callGroovyObjectGetProperty((Object)this));
            }
        }
    }

    public static Dependency<Step> finished(String repositoryName) {
        Reference repositoryName2 = new Reference((Object)repositoryName);
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        return new Dependency<Step>(RepositoryFinishStep.class, repositoryName2){
            public /* synthetic */ Reference repositoryName;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Class clazz;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.repositoryName = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public boolean satisfiedBy(Step other) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return other instanceof RepositoryFinishStep ? ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)other), (Object)this.repositoryName.get()) : false;
            }

            public String toString() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.repositoryName.get()}, new String[]{"REPOSITORY-FINISHED(", ")"}));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, RepositoryFinishStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, RepositoryFinishStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, RepositoryFinishStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "repositoryName";
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RepositoryFinishStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoryFinishStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = RepositoryFinishStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(RepositoryFinishStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RepositoryFinishStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    public RepositoryMigrationManager getRepositoryMigrationManager() {
        return this.repositoryMigrationManager;
    }

    public void setRepositoryMigrationManager(RepositoryMigrationManager repositoryMigrationManager) {
        this.repositoryMigrationManager = repositoryMigrationManager;
    }

    public RepositoryClient getRepositoryClient() {
        return this.repositoryClient;
    }

    public void setRepositoryClient(RepositoryClient repositoryClient) {
        this.repositoryClient = repositoryClient;
    }

    public RepositoryMigrationClient getRepositoryMigrationClient() {
        return this.repositoryMigrationClient;
    }

    public void setRepositoryMigrationClient(RepositoryMigrationClient repositoryMigrationClient) {
        this.repositoryMigrationClient = repositoryMigrationClient;
    }

    public RequestMonitorController getHttpController() {
        return this.httpController;
    }

    public void setHttpController(RequestMonitorController requestMonitorController) {
        this.httpController = requestMonitorController;
    }

    public ConfigService getConfigService() {
        return this.configService;
    }

    public void setConfigService(ConfigService configService) {
        this.configService = configService;
    }

    public HealthCheckTaskManager getTaskManager() {
        return this.taskManager;
    }

    public void setTaskManager(HealthCheckTaskManager healthCheckTaskManager) {
        this.taskManager = healthCheckTaskManager;
    }

    public FirewallMigrationFacade getFirewallMigrationFacade() {
        return this.firewallMigrationFacade;
    }

    public void setFirewallMigrationFacade(FirewallMigrationFacade firewallMigrationFacade) {
        this.firewallMigrationFacade = firewallMigrationFacade;
    }

    public boolean getIqMigrationEnabled() {
        return this.iqMigrationEnabled;
    }

    public boolean isIqMigrationEnabled() {
        return this.iqMigrationEnabled;
    }

    public void setIqMigrationEnabled(boolean bl) {
        this.iqMigrationEnabled = bl;
    }

    public /* synthetic */ void super$3$doInit() {
        super.doInit();
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$doConfigure(Map map) {
        super.doConfigure(map);
    }

    public /* synthetic */ void super$3$doAbort() {
        super.doAbort();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "FINISH";
        stringArray[1] = "repository";
        stringArray[2] = "selectedRepositories";
        stringArray[3] = "iqMigrationEnabled";
        stringArray[4] = "repositoryName";
        stringArray[5] = "get";
        stringArray[6] = "assistant";
        stringArray[7] = "repositoryName";
        stringArray[8] = "checkState";
        stringArray[9] = "repositoryDetail";
        stringArray[10] = "leftShift";
        stringArray[11] = "dependencies";
        stringArray[12] = "purged";
        stringArray[13] = "leftShift";
        stringArray[14] = "dependencies";
        stringArray[15] = "cloneViolationHistory";
        stringArray[16] = "adjustGroupMembersAndDependencies";
        stringArray[17] = "emptyGroup";
        stringArray[18] = "repositoryName";
        stringArray[19] = "info";
        stringArray[20] = "log";
        stringArray[21] = "log";
        stringArray[22] = "current";
        stringArray[23] = "assistant";
        stringArray[24] = "finish";
        stringArray[25] = "repositoryName";
        stringArray[26] = "removeMigrator";
        stringArray[27] = "repositoryName";
        stringArray[28] = "get";
        stringArray[29] = "repositoryManager";
        stringArray[30] = "repositoryName";
        stringArray[31] = "configuration";
        stringArray[32] = "update";
        stringArray[33] = "repositoryManager";
        stringArray[34] = "finalizeWritePolicy";
        stringArray[35] = "maybeConfigureRepositoryHealthCheck";
        stringArray[36] = "maybeActivateFirewallCapability";
        stringArray[37] = "ifPresent";
        stringArray[38] = "optionalFacet";
        stringArray[39] = "removeMigrator";
        stringArray[40] = "repositoryName";
        stringArray[41] = "child";
        stringArray[42] = "attributes";
        stringArray[43] = "facet";
        stringArray[44] = "MIGRATION";
        stringArray[45] = "configuration";
        stringArray[46] = "set";
        stringArray[47] = "attributes";
        stringArray[48] = "STORAGE";
        stringArray[49] = "WRITE_POLICY";
        stringArray[50] = "get";
        stringArray[51] = "WRITE_POLICY";
        stringArray[52] = "update";
        stringArray[53] = "repositoryManager";
        stringArray[54] = "child";
        stringArray[55] = "attributes";
        stringArray[56] = "facet";
        stringArray[57] = "MIGRATION";
        stringArray[58] = "getAt";
        stringArray[59] = "RHC_CONFIGURED";
        stringArray[60] = "getAt";
        stringArray[61] = "RHC_ENABLED";
        stringArray[62] = "setEnabled";
        stringArray[63] = "repositoryName";
        stringArray[64] = "scheduleTask";
        stringArray[65] = "repositoryName";
        stringArray[66] = "stopTask";
        stringArray[67] = "repositoryName";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[68];
        RepositoryFinishStep.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RepositoryFinishStep.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RepositoryFinishStep.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

