/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.assistant.MigrationAssistant;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.RepositoryConfigurationFactory;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import com.sonatype.nexus.migration.repository.RepositoryMigrator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.manager.RepositoryManager;

@Named
@Singleton
public class RepositoryMigrationManagerImpl
extends StateGuardLifecycleSupport
implements RepositoryMigrationManager {
    private final RepositoryManager repositoryManager;
    private final Map<String, Provider<RepositoryMigrator>> migratorFactories;
    private final Map<String, RepositoryConfigurationFactory> configurationFactories;
    private final Map<String, RepositoryMigrator> migrators = new HashMap<String, RepositoryMigrator>();

    @Inject
    public RepositoryMigrationManagerImpl(RepositoryManager repositoryManager, Map<String, Provider<RepositoryMigrator>> migratorFactories, Map<String, RepositoryConfigurationFactory> configurationFactories) {
        this.repositoryManager = (RepositoryManager)Preconditions.checkNotNull((Object)repositoryManager);
        this.migratorFactories = (Map)Preconditions.checkNotNull(migratorFactories);
        this.configurationFactories = (Map)Preconditions.checkNotNull(configurationFactories);
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }

    @Override
    public boolean isSupported(String format, String type, @Nullable List<String> memberRepositoryIds) {
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkNotNull((Object)type);
        if ("group".equals(type) && (memberRepositoryIds == null || memberRepositoryIds.isEmpty())) {
            return false;
        }
        return this.findMigratorFactory(format, type) != null && this.findConfigurationFactory(format, type) != null;
    }

    @Nullable
    private Provider<RepositoryMigrator> findMigratorFactory(Repository repository) {
        String format = repository.getFormat().getValue();
        String type = repository.getType().getValue();
        return this.findMigratorFactory(format, type);
    }

    @Nullable
    private Provider<RepositoryMigrator> findMigratorFactory(String format, String type) {
        this.log.trace("Finding migrator for: {}-{}", (Object)format, (Object)type);
        Provider<RepositoryMigrator> factory = this.migratorFactories.get(String.format("%s-%s", format, type));
        if (factory == null) {
            factory = this.migratorFactories.get(format);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Guarded(by={"STARTED"})
    public RepositoryMigrator createMigrator(MigrationAssistant assistant, String repositoryName, IngestMethod ingestMethod) {
        Preconditions.checkNotNull((Object)assistant);
        Preconditions.checkNotNull((Object)repositoryName);
        Preconditions.checkNotNull((Object)((Object)ingestMethod));
        Map<String, RepositoryMigrator> map = this.migrators;
        synchronized (map) {
            Preconditions.checkState((!this.migrators.containsKey(repositoryName) ? 1 : 0) != 0, (String)"Migrator already exists for repository: %s", (Object)repositoryName);
            Repository repository = this.repositoryManager.get(repositoryName);
            Preconditions.checkState((repository != null ? 1 : 0) != 0, (String)"Missing repository: %s", (Object)repositoryName);
            Provider<RepositoryMigrator> factory = this.findMigratorFactory(repository);
            Preconditions.checkState((factory != null ? 1 : 0) != 0, (String)"Missing migrator factory for: %s", (Object)repository.getName());
            RepositoryMigrator migrator = (RepositoryMigrator)factory.get();
            this.log.debug("Resolved migrator for {}: {}", (Object)repositoryName, (Object)migrator);
            migrator.init(assistant, repository, ingestMethod);
            this.migrators.put(repositoryName, migrator);
            return migrator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public RepositoryMigrator findMigrator(String repositoryName) {
        Preconditions.checkNotNull((Object)repositoryName);
        Map<String, RepositoryMigrator> map = this.migrators;
        synchronized (map) {
            return this.migrators.get(repositoryName);
        }
    }

    @Override
    public RepositoryMigrator getMigrator(String repositoryName) {
        RepositoryMigrator migrator = this.findMigrator(repositoryName);
        Preconditions.checkState((migrator != null ? 1 : 0) != 0, (String)"Missing migrator for repository: %s", (Object)repositoryName);
        return migrator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Guarded(by={"STARTED"})
    public void removeMigrator(String repositoryName) {
        Preconditions.checkNotNull((Object)repositoryName);
        Map<String, RepositoryMigrator> map = this.migrators;
        synchronized (map) {
            this.migrators.remove(repositoryName);
            this.log.debug("Removed migrator: {}", (Object)repositoryName);
        }
    }

    @Override
    @Nullable
    @Guarded(by={"STARTED"})
    public RepositoryConfigurationFactory findConfigurationFactory(String format, String type) {
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkNotNull((Object)type);
        return this.configurationFactories.get(String.format("%s-%s", format, type));
    }
}

