/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.migration.MigrationService;
import com.sonatype.nexus.migration.assistant.MigrationPhases;
import com.sonatype.nexus.migration.client.RepositoryClient;
import com.sonatype.nexus.migration.client.RepositoryMigrationClient;
import com.sonatype.nexus.migration.firewall.FirewallMigrationFacade;
import com.sonatype.nexus.migration.plan.Step;
import com.sonatype.nexus.migration.plan.StepContext;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.IngestionValidation;
import com.sonatype.nexus.migration.repository.RepositoryMigrationManager;
import com.sonatype.nexus.migration.repository.RepositoryMigrationResetStep;
import com.sonatype.nexus.migration.repository.RepositoryMigrator;
import com.sonatype.nexus.migration.repository.RepositoryStepSupport;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.attributes.AttributesFacet;
import org.sonatype.nexus.repository.storage.StorageFacetConstants;
import org.sonatype.nexus.repository.storage.WritePolicy;
import org.sonatype.nexus.upgrade.plan.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named(value="migration.repository")
public class RepositoryPrepareStep
extends RepositoryStepSupport {
    public static final String TYPE_NAME = "migration.repository";
    public static final String MIGRATION = "migration";
    public static final String RHC_CONFIGURED = "rhcConfigured";
    public static final String RHC_ENABLED = "rhcEnabled";
    @Inject
    private MigrationService migrationService;
    @Inject
    private RepositoryMigrationManager repositoryMigrationManager;
    @Inject
    private RepositoryClient repositoryClient;
    @Inject
    private RepositoryMigrationClient repositoryMigrationClient;
    @Inject
    private IngestionValidation ingestionValidation;
    @Inject
    private FirewallMigrationFacade firewallMigrationFacade;
    private String blobStoreName;
    private IngestMethod ingestMethod;
    private RepositoryMigrator migrator;
    private Repository repository;
    private static Dependency<Step> resetDependency;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private static /* synthetic */ SoftReference $callSiteArray;

    public RepositoryPrepareStep() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
    }

    @Override
    public String getType() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return TYPE_NAME;
    }

    @Override
    protected void doConfigure(Map<String, Object> config) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object object = callSiteArray[0].callGetProperty(MigrationPhases.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoryPrepareStep.class, (GroovyObject)this, (String)"phase");
        String string = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[1].callGetProperty(config), String.class);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, RepositoryPrepareStep.class, (GroovyObject)this, (String)"repositoryName");
        String string2 = (String)ScriptBytecodeAdapter.asType((Object)callSiteArray[2].callGetProperty(config), String.class);
        this.blobStoreName = ShortTypeHandling.castToString((Object)string2);
        IngestMethod ingestMethod = (IngestMethod)((Object)ScriptBytecodeAdapter.asType((Object)callSiteArray[3].callGetProperty(config), IngestMethod.class));
        this.ingestMethod = (IngestMethod)ShortTypeHandling.castToEnum((Object)((Object)ingestMethod), IngestMethod.class);
        Object object2 = callSiteArray[4].callGetProperty(config);
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object2, RepositoryPrepareStep.class, (GroovyObject)this, (String)"selectedRepositories");
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[5].callGetProperty(config)}, new String[]{"Prepare repository for upgrade: ", ""});
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)gStringImpl, RepositoryPrepareStep.class, (GroovyObject)this, (String)"name");
    }

    @Override
    protected void doInit() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object repo = callSiteArray[6].call(callSiteArray[7].callGroovyObjectGetProperty((Object)this), callSiteArray[8].callGroovyObjectGetProperty((Object)this));
        callSiteArray[9].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareEqual((Object)repo, null), (Object)"Repository already exists: %s", callSiteArray[10].callGroovyObjectGetProperty((Object)this));
        Object object = callSiteArray[11].call((Object)this.repositoryClient, callSiteArray[12].callGetProperty((Object)this.migrationService), callSiteArray[13].callGroovyObjectGetProperty((Object)this));
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)((RepositoryClient.RepositoryDetailXO)ScriptBytecodeAdapter.castToType((Object)object, RepositoryClient.RepositoryDetailXO.class)), RepositoryPrepareStep.class, (GroovyObject)this, (String)"repositoryDetail");
        callSiteArray[14].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)callSiteArray[15].callGroovyObjectGetProperty((Object)this), null), (Object)"Failed to fetch repository details from remote agent");
        callSiteArray[16].call(callSiteArray[17].callGroovyObjectGetProperty((Object)this), (Object)"Fetched repository details for {}: {}", callSiteArray[18].callGroovyObjectGetProperty((Object)this), callSiteArray[19].callGroovyObjectGetProperty((Object)this));
        Object availableMethods = callSiteArray[20].call((Object)this.ingestionValidation, callSiteArray[21].callGroovyObjectGetProperty((Object)this), (Object)this.blobStoreName);
        callSiteArray[22].callStatic(Preconditions.class, ArrayUtil.createArray((Object)ScriptBytecodeAdapter.isCase((Object)((Object)this.ingestMethod), (Object)availableMethods), (Object)"Ingestion method %s unavailable from repository %s to blob store %s. Allowed: %s", (Object)((Object)this.ingestMethod), (Object)callSiteArray[23].callGroovyObjectGetProperty((Object)this), (Object)this.blobStoreName, (Object)callSiteArray[24].call(Arrays.class, availableMethods)));
        callSiteArray[25].callCurrent((GroovyObject)this, (Object)ScriptBytecodeAdapter.getMethodPointer((Object)((Object)this), (String)"prepared"));
        callSiteArray[26].call(callSiteArray[27].callGroovyObjectGetProperty((Object)this), resetDependency);
    }

    @Override
    protected void doRun() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[28].callGroovyObjectGetProperty((Object)this))) {
            GStringImpl msg = new GStringImpl(new Object[]{callSiteArray[29].callGroovyObjectGetProperty((Object)this)}, new String[]{"Group repository would be empty and will not be created: ", ""});
            callSiteArray[30].call(callSiteArray[31].callGroovyObjectGetProperty((Object)this), (Object)msg);
            callSiteArray[32].call(callSiteArray[33].callGetProperty(StepContext.class), (Object)msg);
        } else {
            Object assistant = callSiteArray[34].callGetProperty((Object)this.migrationService);
            Object format = callSiteArray[35].callGetProperty(callSiteArray[36].callGroovyObjectGetProperty((Object)this));
            Object type = callSiteArray[37].callGetProperty(callSiteArray[38].callGroovyObjectGetProperty((Object)this));
            Object configurationFactory = callSiteArray[39].call((Object)this.repositoryMigrationManager, format, type);
            callSiteArray[40].callStatic(Preconditions.class, (Object)ScriptBytecodeAdapter.compareNotEqual((Object)configurationFactory, null), (Object)"Missing repository-configuration factory: %s-%s", format, type);
            Object repositoryConfig = callSiteArray[41].call(configurationFactory, callSiteArray[42].callGetProperty(callSiteArray[43].callGroovyObjectGetProperty((Object)this)));
            Object object = callSiteArray[44].callGroovyObjectGetProperty((Object)this);
            ScriptBytecodeAdapter.setProperty((Object)object, null, (Object)repositoryConfig, (String)"repositoryName");
            callSiteArray[45].call(callSiteArray[46].call(repositoryConfig, callSiteArray[47].callGetProperty(StorageFacetConstants.class)), callSiteArray[48].callGetProperty(StorageFacetConstants.class), (Object)this.blobStoreName);
            boolean bl = false;
            ScriptBytecodeAdapter.setProperty((Object)bl, null, (Object)repositoryConfig, (String)"online");
            Object object2 = callSiteArray[49].call(callSiteArray[50].callGroovyObjectGetProperty((Object)this), repositoryConfig);
            this.repository = (Repository)ScriptBytecodeAdapter.castToType((Object)object2, Repository.class);
            callSiteArray[51].callCurrent((GroovyObject)this, (Object)this.repository);
            callSiteArray[52].callCurrent((GroovyObject)this, (Object)this.repository, callSiteArray[53].callGroovyObjectGetProperty((Object)this));
            callSiteArray[54].call((Object)this.firewallMigrationFacade, (Object)this.repository, callSiteArray[55].callGroovyObjectGetProperty((Object)this));
            callSiteArray[56].call((Object)this.repositoryMigrationClient, assistant, callSiteArray[57].callGroovyObjectGetProperty((Object)this));
            callSiteArray[58].call((Object)this.repositoryMigrationClient, assistant, callSiteArray[59].callGroovyObjectGetProperty((Object)this));
            Object object3 = callSiteArray[60].call((Object)this.repositoryMigrationManager, assistant, callSiteArray[61].callGroovyObjectGetProperty((Object)this), (Object)this.ingestMethod);
            this.migrator = (RepositoryMigrator)ScriptBytecodeAdapter.castToType((Object)object3, RepositoryMigrator.class);
        }
    }

    private void allowWrite(Repository repository) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object config = callSiteArray[62].callGetProperty((Object)repository);
        Reference writePolicy = new Reference((Object)((WritePolicy)ShortTypeHandling.castToEnum((Object)callSiteArray[63].call(callSiteArray[64].call(config, callSiteArray[65].callGetProperty(StorageFacetConstants.class)), callSiteArray[66].callGetProperty(StorageFacetConstants.class)), WritePolicy.class)));
        callSiteArray[67].call(callSiteArray[68].call((Object)repository, AttributesFacet.class), (Object)new GeneratedClosure((Object)this, (Object)this, writePolicy){
            private /* synthetic */ Reference writePolicy;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                Reference reference;
                CallSite[] callSiteArray = _allowWrite_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.writePolicy = reference = writePolicy;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _allowWrite_closure1.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].call(it, callSiteArray[2].callGetProperty(RepositoryPrepareStep.class)), callSiteArray[3].callGetProperty(StorageFacetConstants.class), this.writePolicy.get());
            }

            public WritePolicy getWritePolicy() {
                CallSite[] callSiteArray = _allowWrite_closure1.$getCallSiteArray();
                return (WritePolicy)ShortTypeHandling.castToEnum((Object)this.writePolicy.get(), WritePolicy.class);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _allowWrite_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _allowWrite_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "set";
                stringArray[1] = "child";
                stringArray[2] = "MIGRATION";
                stringArray[3] = "WRITE_POLICY";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _allowWrite_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_allowWrite_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _allowWrite_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        });
        callSiteArray[69].call(callSiteArray[70].call(config, callSiteArray[71].callGetProperty(StorageFacetConstants.class)), callSiteArray[72].callGetProperty(StorageFacetConstants.class), callSiteArray[73].callGetProperty(WritePolicy.class));
        callSiteArray[74].call(callSiteArray[75].callGroovyObjectGetProperty((Object)this), config);
    }

    private void recordRepositoryHealthCheckStatus(Repository repository, RepositoryClient.RepositoryDetailXO repositoryDetail) {
        Reference repositoryDetail2 = new Reference((Object)repositoryDetail);
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[76].call(callSiteArray[77].callGetProperty((Object)((RepositoryClient.RepositoryDetailXO)repositoryDetail2.get())), (Object)RHC_CONFIGURED))) {
            callSiteArray[78].call(callSiteArray[79].call((Object)repository, AttributesFacet.class), (Object)new GeneratedClosure((Object)this, (Object)this, repositoryDetail2){
                private /* synthetic */ Reference repositoryDetail;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;
                {
                    Reference reference;
                    CallSite[] callSiteArray = _recordRepositoryHealthCheckStatus_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.repositoryDetail = reference = repositoryDetail;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _recordRepositoryHealthCheckStatus_closure2.$getCallSiteArray();
                    callSiteArray[0].call(callSiteArray[1].call(it, callSiteArray[2].callGetProperty(RepositoryPrepareStep.class)), callSiteArray[3].callGetProperty(RepositoryPrepareStep.class), (Object)true);
                    return callSiteArray[4].call(callSiteArray[5].call(it, callSiteArray[6].callGetProperty(RepositoryPrepareStep.class)), callSiteArray[7].callGetProperty(RepositoryPrepareStep.class), (Object)ScriptBytecodeAdapter.createPojoWrapper((Object)((Boolean)ScriptBytecodeAdapter.asType((Object)callSiteArray[8].call(callSiteArray[9].callGetProperty(this.repositoryDetail.get()), callSiteArray[10].callGetProperty(RepositoryPrepareStep.class)), Boolean.class)), Boolean.class));
                }

                public RepositoryClient.RepositoryDetailXO getRepositoryDetail() {
                    CallSite[] callSiteArray = _recordRepositoryHealthCheckStatus_closure2.$getCallSiteArray();
                    return (RepositoryClient.RepositoryDetailXO)ScriptBytecodeAdapter.castToType((Object)this.repositoryDetail.get(), RepositoryClient.RepositoryDetailXO.class);
                }

                public Object doCall() {
                    CallSite[] callSiteArray = _recordRepositoryHealthCheckStatus_closure2.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _recordRepositoryHealthCheckStatus_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "set";
                    stringArray[1] = "child";
                    stringArray[2] = "MIGRATION";
                    stringArray[3] = "RHC_CONFIGURED";
                    stringArray[4] = "set";
                    stringArray[5] = "child";
                    stringArray[6] = "MIGRATION";
                    stringArray[7] = "RHC_ENABLED";
                    stringArray[8] = "getAt";
                    stringArray[9] = "attributes";
                    stringArray[10] = "RHC_ENABLED";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[11];
                    _recordRepositoryHealthCheckStatus_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_recordRepositoryHealthCheckStatus_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _recordRepositoryHealthCheckStatus_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            });
        }
    }

    @Override
    protected void doAbort() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        if (DefaultTypeTransformation.booleanUnbox((Object)this.repository)) {
            callSiteArray[80].call(callSiteArray[81].callGroovyObjectGetProperty((Object)this), callSiteArray[82].callGroovyObjectGetProperty((Object)this));
        }
        callSiteArray[83].call((Object)this.repositoryMigrationClient, callSiteArray[84].callGetProperty((Object)this.migrationService), callSiteArray[85].callGroovyObjectGetProperty((Object)this));
        callSiteArray[86].call((Object)this.repositoryMigrationManager, callSiteArray[87].callGroovyObjectGetProperty((Object)this));
    }

    @Override
    protected void doDestroy() {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object var2_2 = null;
        this.repository = (Repository)ScriptBytecodeAdapter.castToType(var2_2, Repository.class);
        Object var3_3 = null;
        this.migrator = (RepositoryMigrator)ScriptBytecodeAdapter.castToType(var3_3, RepositoryMigrator.class);
    }

    public static Dependency<Step> prepared(String repositoryName) {
        Reference repositoryName2 = new Reference((Object)repositoryName);
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return new Dependency<Step>(RepositoryPrepareStep.class, repositoryName2){
            public /* synthetic */ Reference repositoryName;
            public /* synthetic */ Class this$0;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private transient /* synthetic */ MetaClass metaClass;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                MetaClass metaClass;
                Reference reference;
                Class clazz;
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                this.this$0 = clazz = p0;
                this.repositoryName = reference = p1;
                this.metaClass = metaClass = this.$getStaticMetaClass();
            }

            public boolean satisfiedBy(Step other) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return other instanceof RepositoryPrepareStep ? ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[0].callGetProperty((Object)other), (Object)this.repositoryName.get()) : false;
            }

            public String toString() {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.repositoryName.get()}, new String[]{"REPOSITORY-PREPARED(", ")"}));
            }

            public /* synthetic */ Object methodMissing(String name, Object args) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.invokeMethodN(1.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
            }

            public /* synthetic */ void propertyMissing(String name, Object val) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                Object object = val;
                ScriptBytecodeAdapter.setProperty((Object)object, null, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            public /* synthetic */ Object propertyMissing(String name) {
                CallSite[] callSiteArray = 1.$getCallSiteArray();
                return ScriptBytecodeAdapter.getProperty(1.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (this.getClass() != 1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)this);
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
                }
                return classInfo.getMetaClass();
            }

            public /* synthetic */ MetaClass getMetaClass() {
                MetaClass metaClass = this.metaClass;
                if (metaClass != null) {
                    return metaClass;
                }
                this.metaClass = this.$getStaticMetaClass();
                return this.metaClass;
            }

            public /* synthetic */ void setMetaClass(MetaClass metaClass) {
                this.metaClass = metaClass;
            }

            public /* synthetic */ Object invokeMethod(String string, Object object) {
                return this.getMetaClass().invokeMethod((Object)this, string, object);
            }

            public /* synthetic */ Object getProperty(String string) {
                return this.getMetaClass().getProperty((Object)this, string);
            }

            public /* synthetic */ void setProperty(String string, Object object) {
                this.getMetaClass().setProperty((Object)this, string, object);
            }

            public /* synthetic */ String super$1$toString() {
                return super.toString();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "repositoryName";
                return new CallSiteArray(1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = 1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        };
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(RepositoryPrepareStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, RepositoryPrepareStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        CallSite[] callSiteArray = RepositoryPrepareStep.$getCallSiteArray();
        return ScriptBytecodeAdapter.getGroovyObjectProperty(RepositoryPrepareStep.class, (GroovyObject)this, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RepositoryPrepareStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        2 var0;
        resetDependency = var0 = new 2(RepositoryPrepareStep.class);
    }

    public MigrationService getMigrationService() {
        return this.migrationService;
    }

    public void setMigrationService(MigrationService migrationService) {
        this.migrationService = migrationService;
    }

    public RepositoryMigrationManager getRepositoryMigrationManager() {
        return this.repositoryMigrationManager;
    }

    public void setRepositoryMigrationManager(RepositoryMigrationManager repositoryMigrationManager) {
        this.repositoryMigrationManager = repositoryMigrationManager;
    }

    public RepositoryClient getRepositoryClient() {
        return this.repositoryClient;
    }

    public void setRepositoryClient(RepositoryClient repositoryClient) {
        this.repositoryClient = repositoryClient;
    }

    public RepositoryMigrationClient getRepositoryMigrationClient() {
        return this.repositoryMigrationClient;
    }

    public void setRepositoryMigrationClient(RepositoryMigrationClient repositoryMigrationClient) {
        this.repositoryMigrationClient = repositoryMigrationClient;
    }

    public IngestionValidation getIngestionValidation() {
        return this.ingestionValidation;
    }

    public void setIngestionValidation(IngestionValidation ingestionValidation) {
        this.ingestionValidation = ingestionValidation;
    }

    public FirewallMigrationFacade getFirewallMigrationFacade() {
        return this.firewallMigrationFacade;
    }

    public void setFirewallMigrationFacade(FirewallMigrationFacade firewallMigrationFacade) {
        this.firewallMigrationFacade = firewallMigrationFacade;
    }

    public static Dependency<Step> getResetDependency() {
        return resetDependency;
    }

    public static void setResetDependency(Dependency<Step> dependency) {
        resetDependency = dependency;
    }

    public /* synthetic */ void super$3$doInit() {
        super.doInit();
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public /* synthetic */ void super$3$doConfigure(Map map) {
        super.doConfigure(map);
    }

    public /* synthetic */ void super$3$doAbort() {
        super.doAbort();
    }

    public /* synthetic */ void super$3$doDestroy() {
        super.doDestroy();
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "PREPARE";
        stringArray[1] = "repository";
        stringArray[2] = "blobStore";
        stringArray[3] = "ingestMethod";
        stringArray[4] = "selectedRepositories";
        stringArray[5] = "repository";
        stringArray[6] = "get";
        stringArray[7] = "repositoryManager";
        stringArray[8] = "repositoryName";
        stringArray[9] = "checkState";
        stringArray[10] = "repositoryName";
        stringArray[11] = "get";
        stringArray[12] = "assistant";
        stringArray[13] = "repositoryName";
        stringArray[14] = "checkState";
        stringArray[15] = "repositoryDetail";
        stringArray[16] = "debug";
        stringArray[17] = "log";
        stringArray[18] = "repositoryName";
        stringArray[19] = "repositoryDetail";
        stringArray[20] = "availableMethods";
        stringArray[21] = "repositoryName";
        stringArray[22] = "checkState";
        stringArray[23] = "repositoryName";
        stringArray[24] = "toString";
        stringArray[25] = "adjustGroupMembersAndDependencies";
        stringArray[26] = "leftShift";
        stringArray[27] = "dependencies";
        stringArray[28] = "emptyGroup";
        stringArray[29] = "repositoryName";
        stringArray[30] = "warn";
        stringArray[31] = "log";
        stringArray[32] = "log";
        stringArray[33] = "current";
        stringArray[34] = "assistant";
        stringArray[35] = "format";
        stringArray[36] = "repositoryDetail";
        stringArray[37] = "type";
        stringArray[38] = "repositoryDetail";
        stringArray[39] = "findConfigurationFactory";
        stringArray[40] = "checkState";
        stringArray[41] = "create";
        stringArray[42] = "attributes";
        stringArray[43] = "repositoryDetail";
        stringArray[44] = "repositoryName";
        stringArray[45] = "set";
        stringArray[46] = "attributes";
        stringArray[47] = "STORAGE";
        stringArray[48] = "BLOB_STORE_NAME";
        stringArray[49] = "create";
        stringArray[50] = "repositoryManager";
        stringArray[51] = "allowWrite";
        stringArray[52] = "recordRepositoryHealthCheckStatus";
        stringArray[53] = "repositoryDetail";
        stringArray[54] = "maybeRecordRepositoryFirewallAttributes";
        stringArray[55] = "repositoryDetail";
        stringArray[56] = "begin";
        stringArray[57] = "repositoryName";
        stringArray[58] = "initiate";
        stringArray[59] = "repositoryName";
        stringArray[60] = "createMigrator";
        stringArray[61] = "repositoryName";
        stringArray[62] = "configuration";
        stringArray[63] = "get";
        stringArray[64] = "attributes";
        stringArray[65] = "STORAGE";
        stringArray[66] = "WRITE_POLICY";
        stringArray[67] = "modifyAttributes";
        stringArray[68] = "facet";
        stringArray[69] = "set";
        stringArray[70] = "attributes";
        stringArray[71] = "STORAGE";
        stringArray[72] = "WRITE_POLICY";
        stringArray[73] = "ALLOW";
        stringArray[74] = "update";
        stringArray[75] = "repositoryManager";
        stringArray[76] = "getAt";
        stringArray[77] = "attributes";
        stringArray[78] = "modifyAttributes";
        stringArray[79] = "facet";
        stringArray[80] = "delete";
        stringArray[81] = "repositoryManager";
        stringArray[82] = "repositoryName";
        stringArray[83] = "finish";
        stringArray[84] = "assistant";
        stringArray[85] = "repositoryName";
        stringArray[86] = "removeMigrator";
        stringArray[87] = "repositoryName";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[88];
        RepositoryPrepareStep.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(RepositoryPrepareStep.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = RepositoryPrepareStep.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class 2
    implements Dependency<Step>,
    GroovyObject {
        public /* synthetic */ Class this$0;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ SoftReference $callSiteArray;

        /* synthetic */ 2(Class p0) {
            MetaClass metaClass;
            Class clazz;
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            this.this$0 = clazz = p0;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public boolean satisfiedBy(Step other) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return other instanceof RepositoryMigrationResetStep;
        }

        public String toString() {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return "REPOSITORY-MIGRATION-RESET";
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return ScriptBytecodeAdapter.invokeMethodN(2.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            CallSite[] callSiteArray = 2.$getCallSiteArray();
            return ScriptBytecodeAdapter.getProperty(2.class, RepositoryPrepareStep.class, (String)ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""})));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != 2.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(2.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = 2.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }
    }
}

