/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.repository.migrators.RepositoryMigratorSupport;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Format;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.maven.MavenFacet;
import org.sonatype.nexus.repository.maven.MavenPath;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;

public class Maven2RepositoryMigratorSupport
extends RepositoryMigratorSupport {
    protected static final String ARTIFACT_ID = "artifactId";
    protected static final String BASE_VERSION = "baseVersion";
    protected static final String CLASSIFIER = "classifier";
    protected static final String EXTENSION = "extension";
    protected static final String GROUP_ID = "groupId";
    protected static final String MAVEN2 = "maven2";

    @Override
    @Nullable
    protected Asset recordMetadata(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenPath mavenPath = ((MavenFacet)this.getRepository().facet(MavenFacet.class)).getMavenPathParser().parsePath(this.getAssetName(change), false);
        return this.getOrCreateAsset(tx, mavenPath, change);
    }

    protected Asset getOrCreateAsset(StorageTx tx, MavenPath mavenPath, String assetKind) {
        Asset asset = mavenPath.getCoordinates() == null ? this.maybeCreateDetachedAsset(tx, mavenPath) : this.maybeCreateAsset(tx, mavenPath);
        NestedAttributesMap assetFormatAttr = asset.formatAttributes();
        assetFormatAttr.set("asset_kind", (Object)assetKind);
        asset.markAsDownloaded();
        return asset;
    }

    protected Asset getOrCreateAsset(StorageTx tx, MavenPath mavenPath, RepositoryChangelogClient.ChangeEntryXO change) {
        return this.getOrCreateAsset(tx, mavenPath, (String)change.getChange().getAsset().attributes().child(MAVEN2).get("asset_kind", String.class));
    }

    private Asset maybeCreateAsset(StorageTx tx, MavenPath mavenPath) {
        Asset asset;
        MavenPath.Coordinates coordinates = (MavenPath.Coordinates)Preconditions.checkNotNull((Object)mavenPath.getCoordinates());
        String assetName = mavenPath.getPath();
        String artifactId = coordinates.getArtifactId();
        String groupId = coordinates.getGroupId();
        String version = coordinates.getVersion();
        String baseVersion = coordinates.getBaseVersion();
        Bucket bucket = tx.findBucket(this.getRepository());
        Format format = this.getRepository().getFormat();
        Component component = Maven2RepositoryMigratorSupport.findComponent(tx, this.getRepository(), groupId, artifactId, version);
        if (component == null) {
            component = ((Component)tx.createComponent(bucket, format).group(groupId).name(artifactId)).version(version);
            component.formatAttributes().set(GROUP_ID, (Object)groupId);
            component.formatAttributes().set(ARTIFACT_ID, (Object)artifactId);
            component.formatAttributes().set("version", (Object)version);
            component.formatAttributes().set(BASE_VERSION, (Object)baseVersion);
            tx.saveComponent(component);
        }
        if ((asset = tx.findAssetWithProperty("name", (Object)assetName, component)) == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(assetName);
        }
        NestedAttributesMap assetFormatAttr = asset.formatAttributes();
        assetFormatAttr.set(GROUP_ID, (Object)groupId);
        assetFormatAttr.set(ARTIFACT_ID, (Object)artifactId);
        assetFormatAttr.set("version", (Object)version);
        assetFormatAttr.set(BASE_VERSION, (Object)baseVersion);
        assetFormatAttr.set(CLASSIFIER, (Object)coordinates.getClassifier());
        assetFormatAttr.set(EXTENSION, (Object)coordinates.getExtension());
        return asset;
    }

    private Asset maybeCreateDetachedAsset(StorageTx tx, MavenPath mavenPath) {
        String assetName = mavenPath.getPath();
        Bucket bucket = tx.findBucket(this.getRepository());
        Format format = this.getRepository().getFormat();
        Asset asset = tx.findAssetWithProperty("name", (Object)assetName, bucket);
        if (asset == null) {
            asset = tx.createAsset(bucket, format);
            asset.name(assetName);
        }
        return asset;
    }

    @Override
    protected void delete(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenFacet mavenFacet = (MavenFacet)this.getRepository().facet(MavenFacet.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(this.getItemPath(change), false);
        this.inStorageTx(() -> {
            mavenFacet.delete(new MavenPath[]{mavenPath});
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void streamContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenFacet mavenFacet = (MavenFacet)this.getRepository().facet(MavenFacet.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(this.getAssetName(change), false);
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            TempBlob blob = this.getTempBlob(change);
            try {
                if (blob == null) {
                    return;
                }
                this.inStorageTx(() -> {
                    mavenFacet.put(mavenPath, blob, this.getContentType(change), new AttributesMap(Collections.singletonMap("lastModified", this.getLastUpdated(change))));
                    return null;
                });
                return;
            }
            finally {
                if (blob == null) return;
                blob.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    @Override
    public List<HashAlgorithm> getRequiredHashAlgorithms() {
        return MavenPath.HashType.ALGORITHMS;
    }

    @Override
    protected void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        Map<HashAlgorithm, HashCode> hashes = this.getHashCodes(change);
        MavenFacet mavenFacet = (MavenFacet)this.getRepository().facet(MavenFacet.class);
        MavenPath mavenPath = mavenFacet.getMavenPathParser().parsePath(this.getAssetName(change), false);
        AttributesMap contentAttributes = new AttributesMap(change){
            {
                this.set("lastModified", Maven2RepositoryMigratorSupport.this.getLastUpdated(changeEntryXO));
            }
        };
        this.inStorageTx(() -> {
            mavenFacet.put(mavenPath, this.getStoragePath(change), this.getContentType(change), contentAttributes, hashes, this.getSize(change));
            return null;
        });
    }

    @Override
    @Nullable
    protected Asset getIngestedContent(StorageTx tx, RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        MavenPath mavenPath = ((MavenFacet)this.getRepository().facet(MavenFacet.class)).getMavenPathParser().parsePath(this.getAssetName(change), false);
        MavenPath.Coordinates coordinates = mavenPath.getCoordinates();
        if (coordinates == null) {
            return null;
        }
        String assetName = mavenPath.getPath();
        String artifactId = coordinates.getArtifactId();
        String groupId = coordinates.getGroupId();
        String version = coordinates.getVersion();
        Component component = Maven2RepositoryMigratorSupport.findComponent(tx, this.getRepository(), groupId, artifactId, version);
        if (component == null) {
            return null;
        }
        return tx.findAssetWithProperty("name", (Object)assetName, component);
    }

    @Nullable
    private static Component findComponent(StorageTx tx, Repository repository, String groupId, String artifactId, String version) {
        if (groupId != null && artifactId != null && version != null) {
            Iterable components = tx.findComponents(Query.builder().where("group").eq((Object)groupId).and("name").eq((Object)artifactId).and("version").eq((Object)version).build(), Collections.singletonList(repository));
            return (Component)Iterables.getFirst((Iterable)components, null);
        }
        return null;
    }
}

