/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.migration.repository.migrators;

import com.google.common.base.Preconditions;
import com.google.common.hash.HashCode;
import com.sonatype.nexus.migration.assistant.MigrationAssistant;
import com.sonatype.nexus.migration.client.RepositoryChangelogClient;
import com.sonatype.nexus.migration.client.RepositoryClient;
import com.sonatype.nexus.migration.client.RepositoryContentClient;
import com.sonatype.nexus.migration.client.http.ClientRequestMonitor;
import com.sonatype.nexus.migration.firewall.FirewallMigrationFacade;
import com.sonatype.nexus.migration.repository.IngestMethod;
import com.sonatype.nexus.migration.repository.RepositoryMigrator;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.ServerErrorException;
import org.joda.time.DateTime;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.transaction.Operation;
import org.sonatype.nexus.transaction.UnitOfWork;

public abstract class RepositoryMigratorSupport
extends ComponentSupport
implements RepositoryMigrator {
    protected static final String ASSET_KIND = "asset_kind";
    protected static final String CHECKSUM = "checksum";
    protected static final String CONTENT = "content";
    protected static final String CONTENT_TYPE = "content_type";
    protected static final String GROUP = "group";
    protected static final String LAST_UPDATED = "last_updated";
    protected static final String NAME = "name";
    protected static final String SIZE = "size";
    protected static final String VERSION = "version";
    private MigrationAssistant assistant;
    private volatile boolean initialized = false;
    private Repository repository;
    private IngestMethod ingestMethod;
    private ClientRequestMonitor requestMonitor;
    private FirewallMigrationFacade firewallMigrationFacade;
    private boolean ingestBytes = SystemPropertiesHelper.getBoolean((String)(String.valueOf(RepositoryMigratorSupport.class.getName()) + ".ingest"), (boolean)true);
    private RepositoryClient repositoryClient;
    private RepositoryContentClient contentClient;
    private volatile Path storageDir;

    @Inject
    public void setRequestMonitor(ClientRequestMonitor requestMonitor) {
        this.requestMonitor = (ClientRequestMonitor)Preconditions.checkNotNull((Object)requestMonitor);
    }

    @Inject
    public void setFirewallMigrationFacade(FirewallMigrationFacade firewallMigrationFacade) {
        this.firewallMigrationFacade = (FirewallMigrationFacade)Preconditions.checkNotNull((Object)firewallMigrationFacade);
    }

    @Override
    public void init(MigrationAssistant assistant, Repository repository, IngestMethod ingestMethod) {
        Preconditions.checkState((!this.initialized ? 1 : 0) != 0, (Object)"Already initialized");
        this.assistant = (MigrationAssistant)Preconditions.checkNotNull((Object)assistant);
        this.repository = (Repository)Preconditions.checkNotNull((Object)repository);
        this.ingestMethod = (IngestMethod)((Object)Preconditions.checkNotNull((Object)((Object)ingestMethod)));
        this.log.debug("Ingesting content for repository {} using method {}", (Object)repository.getName(), (Object)ingestMethod);
        if (!this.ingestBytes) {
            this.log.info("Upgrade will not ingest content bytes, only metadata.");
        }
        this.initialized = true;
    }

    protected void ensureInitialized() {
        Preconditions.checkState((boolean)this.initialized, (Object)"Not initialized");
    }

    @Override
    public Repository getRepository() {
        this.ensureInitialized();
        return this.repository;
    }

    @Override
    public IngestMethod getIngestMethod() {
        this.ensureInitialized();
        return this.ingestMethod;
    }

    @Override
    public void processChange(RepositoryChangelogClient.ChangeEntryXO change) throws Exception {
        String type;
        this.ensureInitialized();
        this.log.trace("Processing change: {}", (Object)change);
        switch (type = (String)Preconditions.checkNotNull((Object)change.getChange().getType())) {
            case "UPDATE": 
            case "CREATE": {
                this.createOrUpdate(change);
                break;
            }
            case "UPDATE_DELETED": 
            case "CREATE_DELETED": 
            case "DELETE": {
                this.delete(change);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown change type " + type);
            }
        }
    }

    @Override
    public String calculatePath(RepositoryChangelogClient.ChangeEntryXO change) {
        return change.getChange().getPath();
    }

    private void createOrUpdate(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        this.recordMetadata(change);
        if (this.ingestBytes) {
            this.ingestContent(change);
        }
        this.firewallMigrationFacade.maybeRecordAssetAttributes(this.repository, change, tx -> {
            try {
                return this.getIngestedContent((StorageTx)tx, change);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    public abstract List<HashAlgorithm> getRequiredHashAlgorithms();

    @Nullable
    protected abstract Asset recordMetadata(StorageTx var1, RepositoryChangelogClient.ChangeEntryXO var2) throws IOException;

    protected abstract void delete(RepositoryChangelogClient.ChangeEntryXO var1) throws IOException;

    private void recordMetadata(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        this.inStorageTx(() -> {
            StorageTx tx = (StorageTx)UnitOfWork.currentTx();
            Asset asset = this.recordMetadata(tx, change);
            if (asset != null) {
                tx.saveAsset(asset);
            }
            return null;
        });
    }

    protected void ingestContent(RepositoryChangelogClient.ChangeEntryXO change) throws IOException {
        switch (this.ingestMethod) {
            case FS_LINK: {
                this.hardLinkContent(change);
                break;
            }
            case FS_COPY: {
                this.streamContent(change);
                break;
            }
            case DOWNLOAD: {
                this.streamWithRetry(change);
            }
        }
    }

    private void streamWithRetry(RepositoryChangelogClient.ChangeEntryXO change) {
        while (this.requestMonitor.isIndefiniteRetry()) {
            try {
                this.requestMonitor.maybeDelayRequest();
                this.streamContent(change);
                this.requestMonitor.requestSuccessful();
                return;
            }
            catch (IOException | ServerErrorException e) {
                this.requestMonitor.requestFailed(e.getMessage());
            }
        }
    }

    protected abstract void streamContent(RepositoryChangelogClient.ChangeEntryXO var1) throws IOException;

    protected abstract void hardLinkContent(RepositoryChangelogClient.ChangeEntryXO var1) throws IOException;

    @Nullable
    protected abstract Asset getIngestedContent(StorageTx var1, RepositoryChangelogClient.ChangeEntryXO var2) throws IOException;

    protected <T> T inStorageTx(Operation<T, IOException> operation) throws IOException {
        return (T)TransactionalStoreBlob.operation.withDb(((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier()).throwing(IOException.class).call(operation);
    }

    @Inject
    public void setRepositoryClient(RepositoryClient repositoryClient) {
        this.repositoryClient = (RepositoryClient)((Object)Preconditions.checkNotNull((Object)((Object)repositoryClient)));
    }

    @Inject
    public void setContentClient(RepositoryContentClient contentClient) {
        this.contentClient = (RepositoryContentClient)((Object)Preconditions.checkNotNull((Object)((Object)contentClient)));
    }

    protected Path getStorageDir() {
        if (this.storageDir == null) {
            this.storageDir = Paths.get(this.repositoryClient.get(this.assistant, this.repository.getName()).getStorageDir(), new String[0]);
        }
        return this.storageDir;
    }

    protected Path getStoragePath(RepositoryChangelogClient.ChangeEntryXO change) {
        Path storagePath = this.getStorageDir().resolve(this.getItemPath(change));
        if (storagePath.toFile().length() == 0L) {
            this.logEmptyAsset(change);
        }
        return storagePath;
    }

    private void logEmptyAsset(RepositoryChangelogClient.ChangeEntryXO changeEntryXO) {
        this.log.info("Found zero-length path {} in repository {}. Proceeding with migration.", (Object)changeEntryXO.getChange().getPath(), (Object)this.repository.getName());
    }

    protected String getItemPath(RepositoryChangelogClient.ChangeEntryXO change) {
        return change.getChange().getPath().replaceFirst("^/", "");
    }

    protected String getAssetName(RepositoryChangelogClient.ChangeEntryXO change) {
        return change.getChange().getAsset().getName().replaceFirst("^/", "");
    }

    protected String getContentType(RepositoryChangelogClient.ChangeEntryXO change) {
        return (String)change.getChange().getAsset().attributes().child(CONTENT).get(CONTENT_TYPE, String.class);
    }

    protected DateTime getLastUpdated(RepositoryChangelogClient.ChangeEntryXO change) {
        return DateTime.parse((String)((String)change.getChange().getAsset().attributes().child(CONTENT).get(LAST_UPDATED, String.class)));
    }

    @Nullable
    protected TempBlob getTempBlob(RepositoryChangelogClient.ChangeEntryXO change) {
        StorageFacet storageFacet = (StorageFacet)this.repository.facet(StorageFacet.class);
        TempBlob tempBlob = IngestMethod.FS_COPY == this.ingestMethod ? this.getTempBlobFromCopy(change, storageFacet) : this.getTempBlobFromContentClient(change, storageFacet);
        if (tempBlob != null && tempBlob.getBlob().getMetrics().getContentSize() == 0L) {
            this.logEmptyAsset(change);
        }
        return tempBlob;
    }

    private TempBlob getTempBlobFromCopy(RepositoryChangelogClient.ChangeEntryXO change, StorageFacet storageFacet) {
        Path path = this.getStoragePath(change);
        if (!Files.exists(path, new LinkOption[0])) {
            this.log.debug("File {} not found, skipping", (Object)path);
            return null;
        }
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileInputStream inputStream = new FileInputStream(path.toFile());){
                return storageFacet.createTempBlob((InputStream)inputStream, this.getRequiredHashAlgorithms());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            if (!Files.exists(path, new LinkOption[0])) {
                this.log.debug("File {} not found, skipping", (Object)path);
                return null;
            }
            throw new RuntimeException(e);
        }
    }

    private TempBlob getTempBlobFromContentClient(RepositoryChangelogClient.ChangeEntryXO change, StorageFacet storageFacet) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = this.contentClient.get(this.assistant, this.repository.getName(), this.getItemPath(change));){
                return storageFacet.createTempBlob(inputStream, this.getRequiredHashAlgorithms());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected final Map<HashAlgorithm, HashCode> getHashCodes(RepositoryChangelogClient.ChangeEntryXO change, List<HashAlgorithm> algorithms) {
        NestedAttributesMap checksums = change.getChange().getAsset().attributes().child(CHECKSUM);
        LinkedHashMap<HashAlgorithm, HashCode> hashes = new LinkedHashMap<HashAlgorithm, HashCode>();
        for (HashAlgorithm algorithm : algorithms) {
            hashes.put(algorithm, HashCode.fromString((String)((String)checksums.require(algorithm.name(), String.class))));
        }
        return hashes;
    }

    protected Map<HashAlgorithm, HashCode> getHashCodes(RepositoryChangelogClient.ChangeEntryXO change) {
        return this.getHashCodes(change, this.getRequiredHashAlgorithms());
    }

    protected long getSize(RepositoryChangelogClient.ChangeEntryXO change) {
        Number size = (Number)change.getChange().getAsset().attributes().child(CONTENT).require(SIZE, Number.class);
        return size.longValue();
    }
}

