/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.common.app.ApplicationLicense;

@Named
@Singleton
public class LicensingRedirectFilter
extends ComponentSupport
implements Filter {
    private final Provider<ApplicationLicense> applicationLicense;

    @Inject
    public LicensingRedirectFilter(Provider<ApplicationLicense> applicationLicense) {
        this.applicationLicense = (Provider)Preconditions.checkNotNull(applicationLicense);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ApplicationLicense applicationLicense = (ApplicationLicense)this.applicationLicense.get();
        if (applicationLicense.isRequired() && !applicationLicense.isValid()) {
            this.log.trace("License is invalid");
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            String contextPath = httpRequest.getContextPath();
            String requestUri = httpRequest.getRequestURI();
            String requestPath = requestUri.substring(contextPath.length(), requestUri.length());
            this.log.trace("Request path: {}", (Object)requestPath);
            boolean allow = requestPath.startsWith("/service/rapture/session") || requestPath.startsWith("/service/local/status") || requestPath.startsWith("/service/extdirect") ? true : !requestPath.startsWith("/service") && !requestPath.startsWith("/content") && !requestPath.startsWith("/repository");
            if (!allow) {
                this.log.trace("Deny: {}", (Object)requestPath);
                httpResponse.sendError(402, "Invalid license");
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

