/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.access;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.sonatype.nexus.licensing.access.AccessLogEntry;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.OClassNameBuilder;
import org.sonatype.nexus.orient.OIndexNameBuilder;
import org.sonatype.nexus.orient.entity.IterableEntityAdapter;

@Named
@Singleton
public class AccessLogEntryEntityAdapter
extends IterableEntityAdapter<AccessLogEntry> {
    private static final String DB_CLASS = new OClassNameBuilder().type("entry").build();
    private static final String P_IP = "ip";
    private static final String P_USERID = "userid";
    private static final String P_USERAGENT = "useragent";
    static final String P_TIMESTAMP = "timestamp";
    private static final String I_IP_USERID_USERAGENT = new OIndexNameBuilder().type(DB_CLASS).property("ip").property("userid").property("useragent").build();
    private static final String I_IP = new OIndexNameBuilder().type(DB_CLASS).property("ip").build();
    private static final String I_TIMESTAMP = new OIndexNameBuilder().type(DB_CLASS).property("timestamp").build();
    private static final String STORE_COMMAND = String.format("UPDATE %s SET %s = :%s, %s = :%s, %s = :%s, %s= :%s UPSERT WHERE %s = :%s AND %s = :%s AND %s = :%s", DB_CLASS, "ip", "ip", "userid", "userid", "useragent", "useragent", "timestamp", "timestamp", "ip", "ip", "userid", "userid", "useragent", "useragent");
    private static final String BROWSE_AFTER_QUERY = String.format("SELECT FROM %s WHERE %s > ?", DB_CLASS, "timestamp");
    private static final String BROWSE_FOR_IP_QUERY = String.format("SELECT FROM %s WHERE %s = ?", DB_CLASS, "ip");
    private static final String BROWSE_UNIQUE_IP_QUERY = String.format("SELECT distinct(%s) as ip FROM %s", "ip", DB_CLASS);
    private static final String DELETE_BEFORE_COMMAND = String.format("DELETE FROM %s WHERE %s < ?", DB_CLASS, "timestamp");

    public AccessLogEntryEntityAdapter() {
        super(DB_CLASS);
    }

    protected void defineType(OClass type) {
        type.createProperty(P_IP, OType.STRING).setNotNull(true);
        type.createProperty(P_USERID, OType.STRING).setNotNull(true);
        type.createProperty(P_USERAGENT, OType.STRING).setNotNull(true);
        type.createProperty(P_TIMESTAMP, OType.DATETIME).setNotNull(true);
        type.createIndex(I_IP_USERID_USERAGENT, OClass.INDEX_TYPE.UNIQUE, new String[]{P_IP, P_USERID, P_USERAGENT});
        type.createIndex(I_IP, OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX, new String[]{P_IP});
        type.createIndex(I_TIMESTAMP, OClass.INDEX_TYPE.NOTUNIQUE, new String[]{P_TIMESTAMP});
    }

    protected AccessLogEntry newEntity() {
        return new AccessLogEntry();
    }

    protected void readFields(ODocument document, AccessLogEntry entity) throws Exception {
        entity.setIp((String)document.field(P_IP));
        entity.setUserId((String)document.field(P_USERID));
        entity.setUserAgent((String)document.field(P_USERAGENT));
        entity.setTimestamp((Date)document.field(P_TIMESTAMP));
    }

    protected void writeFields(ODocument document, AccessLogEntry entity) throws Exception {
        document.field(P_IP, (Object)entity.getIp());
        document.field(P_USERID, (Object)entity.getUserId());
        document.field(P_USERAGENT, (Object)entity.getUserAgent());
        document.field(P_TIMESTAMP, (Object)entity.getTimestamp());
    }

    public void addOrUpdate(ODatabaseDocumentTx db, AccessLogEntry entry) {
        OCommandSQL query = new OCommandSQL(STORE_COMMAND);
        HashMap params = Maps.newHashMap();
        params.put(P_IP, entry.getIp());
        params.put(P_USERID, entry.getUserId());
        params.put(P_USERAGENT, entry.getUserAgent());
        params.put(P_TIMESTAMP, entry.getTimestamp());
        db.command((OCommandRequest)query).execute(new Object[]{params});
    }

    public Set<AccessLogEntry> browseAfter(ODatabaseDocumentTx db, Date date) {
        HashSet entries = Sets.newHashSet();
        OSQLSynchQuery query = new OSQLSynchQuery(BROWSE_AFTER_QUERY);
        List result = (List)db.command((OCommandRequest)query).execute(new Object[]{date});
        for (ODocument doc : result) {
            entries.add((AccessLogEntry)this.readEntity(doc));
        }
        return entries;
    }

    public Set<AccessLogEntry> browseForIPAddress(ODatabaseDocumentTx db, String ip) {
        HashSet entries = Sets.newHashSet();
        OSQLSynchQuery query = new OSQLSynchQuery(BROWSE_FOR_IP_QUERY);
        List result = (List)db.command((OCommandRequest)query).execute(new Object[]{ip});
        for (ODocument doc : result) {
            entries.add((AccessLogEntry)this.readEntity(doc));
        }
        return entries;
    }

    public Set<String> browseUniqueIPAddresses(ODatabaseDocumentTx db) {
        HashSet uniqueIPs = Sets.newHashSet();
        OSQLSynchQuery query = new OSQLSynchQuery(BROWSE_UNIQUE_IP_QUERY);
        List result = db.query((OQuery)query, new Object[0]);
        for (ODocument doc : result) {
            uniqueIPs.add((String)doc.field(P_IP, OType.STRING));
        }
        return uniqueIPs;
    }

    public int deleteBefore(ODatabaseDocumentTx db, Date date) {
        Preconditions.checkNotNull((Object)db);
        Preconditions.checkNotNull((Object)date);
        OCommandSQL command = new OCommandSQL(DELETE_BEFORE_COMMAND);
        return (Integer)db.command((OCommandRequest)command).execute(new Object[]{date});
    }

    public boolean resolveConflicts() {
        return true;
    }
}

