/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.access;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sonatype.nexus.licensing.access.AccessLog;
import com.sonatype.nexus.licensing.access.AccessLogEntry;
import com.sonatype.nexus.licensing.internal.access.AccessLogRemover;
import com.sonatype.nexus.licensing.internal.access.AccessLogStore;
import com.sonatype.nexus.licensing.internal.access.AccessLogWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.property.SystemPropertiesHelper;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.common.text.Strings2;

@Named
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SERVICES)
@Singleton
public class AccessLogImpl
extends StateGuardLifecycleSupport
implements AccessLog {
    private static final String NLT_ENABLED_KEY = "nexus.license.tracking";
    private static final boolean NLT_ENABLED = SystemPropertiesHelper.getBoolean((String)"nexus.license.tracking", (boolean)true);
    private final AccessLogStore store;
    private final Provider<AccessLogWriter> writerProvider;
    private final Provider<AccessLogRemover> removerProvider;
    private volatile boolean running;
    private AccessLogWriter writer;
    private AccessLogRemover remover;

    @Inject
    public AccessLogImpl(AccessLogStore store, Provider<AccessLogWriter> writerProvider, Provider<AccessLogRemover> removerProvider) {
        this.store = (AccessLogStore)Preconditions.checkNotNull((Object)store);
        this.writerProvider = (Provider)Preconditions.checkNotNull(writerProvider);
        this.removerProvider = (Provider)Preconditions.checkNotNull(removerProvider);
    }

    protected void doStart() throws Exception {
        this.running = NLT_ENABLED;
        if (!this.running) {
            this.log.info("User license access tracking disabled.");
            return;
        }
        this.writer = (AccessLogWriter)this.writerProvider.get();
        this.writer.start();
        this.remover = (AccessLogRemover)this.removerProvider.get();
        this.remover.start();
    }

    protected void doStop() throws Exception {
        if (!this.running) {
            return;
        }
        this.writer.stopThread();
        this.remover.stopThread();
        this.joinAndIgnoreInterruption(this.writer);
        this.joinAndIgnoreInterruption(this.remover);
    }

    @Override
    @Guarded(by={"STARTED"})
    public void store(AccessLogEntry entry) {
        if (!this.running || entry == null) {
            return;
        }
        if (!this.writer.offer(entry)) {
            this.log.debug("Failed to record access log entry: {}", (Object)entry);
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public CharSequence toCSV(Date time) {
        if (!this.running) {
            return "".intern();
        }
        this.writer.process();
        this.remover.process();
        StringWriter writer = new StringWriter();
        writer.write("\"IP\",\"USER_ID\",\"USER_AGENT\",\"ENTRYDATE\"");
        writer.write(Strings2.NL);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        ArrayList sorted = Lists.newArrayList(this.store.getAfter(time));
        Collections.sort(sorted, new Comparator<AccessLogEntry>(){

            @Override
            public int compare(AccessLogEntry o1, AccessLogEntry o2) {
                return o1.getTimestamp().compareTo(o2.getTimestamp());
            }
        });
        for (AccessLogEntry entry : sorted) {
            writer.write("\"" + entry.getIp() + "\"");
            writer.write(",");
            writer.write("\"" + entry.getUserId() + "\"");
            writer.write(",");
            writer.write("\"" + entry.getUserAgent() + "\"");
            writer.write(",");
            writer.write("\"" + dateFormat.format(entry.getTimestamp()) + "\"");
            writer.write(Strings2.NL);
        }
        return writer.getBuffer();
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<String> getUniqueIPAddresses() {
        if (this.running) {
            this.writer.process();
            this.remover.process();
            return this.store.getUniqueIPAddresses();
        }
        return Collections.emptySet();
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<AccessLogEntry> get() {
        if (this.running) {
            this.writer.process();
            this.remover.process();
            return this.store.get();
        }
        return Collections.emptySet();
    }

    private void joinAndIgnoreInterruption(Thread t) {
        try {
            t.join();
        }
        catch (InterruptedException interruptedException) {}
    }
}

