/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.access;

import com.google.common.base.Preconditions;
import com.sonatype.nexus.licensing.internal.access.AccessLogStore;
import com.sonatype.nexus.licensing.internal.access.AccessLogThreadSupport;
import java.util.Calendar;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named
@Singleton
public class AccessLogRemover
extends AccessLogThreadSupport {
    private static final long PERIODICITY = 120000L;
    private final AccessLogStore store;
    private final Calendar calendar;
    private long lastRan;

    @Inject
    public AccessLogRemover(AccessLogStore store) {
        super("AccessLogDeleter");
        this.store = (AccessLogStore)Preconditions.checkNotNull((Object)store);
        this.calendar = Calendar.getInstance();
        this.lastRan = 0L;
    }

    @Override
    protected void doRun() throws InterruptedException {
        Thread.sleep(2000L);
        if (System.currentTimeMillis() - this.lastRan > 120000L) {
            this.process();
        }
    }

    protected void process() {
        try {
            try {
                this.calendar.setTimeInMillis(System.currentTimeMillis());
                this.calendar.add(6, -7);
                int rowsRemoved = this.store.removeBefore(this.calendar.getTime());
                this.log.debug("Purged {} records, starting from date {}", (Object)rowsRemoved, (Object)this.calendar.getTime());
            }
            catch (Exception e) {
                this.log.warn("Failed to remove records", (Throwable)e);
                this.lastRan = System.currentTimeMillis();
            }
        }
        finally {
            this.lastRan = System.currentTimeMillis();
        }
    }
}

