/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.access;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccessLogThreadSupport
extends Thread {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private volatile boolean running;

    public AccessLogThreadSupport(String name) {
        super(name);
        this.setDaemon(true);
        this.running = true;
    }

    public void stopThread() {
        this.running = false;
    }

    protected boolean isRunning() {
        return this.running;
    }

    @Override
    public void run() {
        try {
            while (this.isRunning()) {
                this.doRun();
            }
        }
        catch (InterruptedException e) {
            this.log.info("Thread {} is interrupted!", (Object)this.getName(), (Object)e);
        }
    }

    protected abstract void doRun() throws InterruptedException;
}

