/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.access;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Iterables;
import com.sonatype.nexus.licensing.access.AccessLogEntry;
import com.sonatype.nexus.licensing.internal.access.AccessLogStore;
import com.sonatype.nexus.licensing.internal.access.AccessLogThreadSupport;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.orient.ReplicationModeOverrides;
import org.sonatype.nexus.security.anonymous.AnonymousManager;

@Named
@Singleton
public class AccessLogWriter
extends AccessLogThreadSupport {
    @VisibleForTesting
    static final int CACHE_LIMIT = 10000;
    private static final int THRESHOLD = 3333;
    private static final int WRITE_PERIOD = 10000;
    private static final String NO_USER_AGENT = "";
    private final AccessLogStore store;
    private final AnonymousManager anonymousManager;
    private final Cache<String, AccessLogEntry> cache;
    private volatile long lastWrite = System.currentTimeMillis();

    @Inject
    public AccessLogWriter(AccessLogStore store, AnonymousManager anonymousManager) {
        super("AccessLogWriter");
        this.store = (AccessLogStore)Preconditions.checkNotNull((Object)store);
        this.anonymousManager = (AnonymousManager)Preconditions.checkNotNull((Object)anonymousManager);
        this.cache = CacheBuilder.newBuilder().maximumSize(10000L).build();
    }

    @Override
    protected void doRun() throws InterruptedException {
        if (this.cache.size() >= 3333L || this.lastWrite + 10000L < System.currentTimeMillis()) {
            this.process();
        } else {
            Thread.sleep(500L);
        }
    }

    public boolean offer(AccessLogEntry entry) {
        this.cache.put((Object)AccessLogWriter.cacheKey(entry), (Object)entry);
        return true;
    }

    private static String cacheKey(AccessLogEntry entry) {
        return String.valueOf(entry.getIp()) + '~' + entry.getUserId() + '~' + entry.getUserAgent();
    }

    protected void process() {
        ReplicationModeOverrides.dontWaitForReplicationResults();
        try {
            this.doProcess();
        }
        finally {
            ReplicationModeOverrides.clearReplicationModeOverrides();
        }
    }

    protected void doProcess() {
        this.lastWrite = System.currentTimeMillis();
        int counter = 0;
        if (this.cache.size() > 0L) {
            String anon = this.anonymousManager.getConfiguration().getUserId();
            try {
                for (AccessLogEntry entry : Iterables.consumingIterable(this.cache.asMap().values())) {
                    String recordedUserId = entry.getUserId();
                    if (recordedUserId == null) {
                        recordedUserId = anon;
                    }
                    AccessLogEntry record = new AccessLogEntry();
                    record.setIp(entry.getIp());
                    record.setUserId(recordedUserId);
                    record.setUserAgent(entry.getUserAgent() == null ? NO_USER_AGENT : entry.getUserAgent());
                    record.setTimestamp(entry.getTimestamp());
                    this.store.addOrUpdate(record);
                    ++counter;
                }
            }
            catch (Exception e) {
                this.log.warn("Failed to write records", (Throwable)e);
            }
        }
        this.log.debug("Wrote {} rows", (Object)counter);
    }

    @Override
    public void stopThread() {
        this.process();
        super.stopThread();
    }
}

