/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.access;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.sonatype.nexus.licensing.access.AccessLog;
import com.sonatype.nexus.licensing.access.AccessLogEntry;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.common.event.EventAware;
import org.sonatype.nexus.security.anonymous.AnonymousAccessEvent;
import org.sonatype.nexus.security.authc.NexusAuthenticationEvent;

@Named(value="UserIPEventInspector")
@Singleton
public class EventsRouter
implements EventAware {
    private final AccessLog accessLog;

    @Inject
    public EventsRouter(AccessLog accessLog) {
        this.accessLog = (AccessLog)Preconditions.checkNotNull((Object)accessLog);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AnonymousAccessEvent event) {
        this.store(event.getClientInfo().getRemoteIP(), event.getClientInfo().getUserid(), event.getClientInfo().getUserAgent(), event.getEventDate());
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(NexusAuthenticationEvent event) {
        if (event.isSuccessful()) {
            this.store(event.getClientInfo().getRemoteIP(), event.getClientInfo().getUserid(), event.getClientInfo().getUserAgent(), event.getEventDate());
        }
    }

    private void store(String remoteIP, String userid, String userAgent, Date timestamp) {
        AccessLogEntry entry = AccessLogEntry.create(remoteIP, userid, userAgent, timestamp);
        if (entry != null) {
            this.accessLog.store(entry);
        }
    }
}

