/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.access;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.orientechnologies.common.concur.ONeedRetryException;
import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.server.distributed.ODistributedException;
import com.orientechnologies.orient.server.distributed.OWriteOperationNotPermittedException;
import com.sonatype.nexus.licensing.access.AccessLogEntry;
import com.sonatype.nexus.licensing.internal.access.AccessLogEntryEntityAdapter;
import com.sonatype.nexus.licensing.internal.access.AccessLogStore;
import java.util.Date;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.sonatype.nexus.common.app.ManagedLifecycle;
import org.sonatype.nexus.common.stateguard.Guarded;
import org.sonatype.nexus.common.stateguard.StateGuardLifecycleSupport;
import org.sonatype.nexus.orient.DatabaseInstance;
import org.sonatype.nexus.orient.transaction.OrientOperations;
import org.sonatype.nexus.orient.transaction.OrientTransactional;

@Named(value="orient")
@ManagedLifecycle(phase=ManagedLifecycle.Phase.SCHEMAS)
@Singleton
public class OrientAccessLogStore
extends StateGuardLifecycleSupport
implements AccessLogStore {
    private final Provider<DatabaseInstance> databaseInstance;
    private final AccessLogEntryEntityAdapter entityAdapter;

    @Inject
    public OrientAccessLogStore(@Named(value="accesslog") Provider<DatabaseInstance> databaseInstance, AccessLogEntryEntityAdapter entryEntityAdapter) {
        this.databaseInstance = (Provider)Preconditions.checkNotNull(databaseInstance);
        this.entityAdapter = (AccessLogEntryEntityAdapter)((Object)Preconditions.checkNotNull((Object)((Object)entryEntityAdapter)));
    }

    protected void doStart() throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (ODatabaseDocumentTx db = ((DatabaseInstance)this.databaseInstance.get()).connect();){
            this.entityAdapter.register(db);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    @Guarded(by={"STARTED"})
    public void addOrUpdate(AccessLogEntry entry) {
        ((OrientOperations)OrientTransactional.inTx(this.databaseInstance).swallow(new Class[]{ONeedRetryException.class, OModificationOperationProhibitedException.class, OWriteOperationNotPermittedException.class})).run(db -> this.entityAdapter.addOrUpdate(db, entry));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<AccessLogEntry> get() {
        return (Set)OrientTransactional.inTx(this.databaseInstance).call(db -> ImmutableSet.copyOf((Iterable)this.entityAdapter.browse(db)));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<AccessLogEntry> getAfter(Date date) {
        return (Set)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.browseAfter(db, date));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<AccessLogEntry> getForIPAddress(String ip) {
        return (Set)OrientTransactional.inTx(this.databaseInstance).call(db -> this.entityAdapter.browseForIPAddress(db, ip));
    }

    @Override
    @Guarded(by={"STARTED"})
    public Set<String> getUniqueIPAddresses() {
        return (Set)OrientTransactional.inTx(this.databaseInstance).call(this.entityAdapter::browseUniqueIPAddresses);
    }

    @Override
    @Guarded(by={"STARTED"})
    public int removeBefore(Date date) {
        return (Integer)((OrientOperations)OrientTransactional.inTxRetry(this.databaseInstance).swallow(new Class[]{OModificationOperationProhibitedException.class, ODistributedException.class})).call(db -> this.entityAdapter.deleteBefore(db, date));
    }
}

