/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.licensing.internal.ui;

import com.codahale.metrics.annotation.ExceptionMetered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Preconditions;
import com.softwarementors.extjs.djn.config.annotations.DirectAction;
import com.softwarementors.extjs.djn.config.annotations.DirectFormPostMethod;
import com.softwarementors.extjs.djn.config.annotations.DirectMethod;
import com.sonatype.nexus.licensing.access.AccessLog;
import com.sonatype.nexus.licensing.internal.LicenseUtil;
import com.sonatype.nexus.licensing.internal.ui.LicenseDetailsXO;
import com.sonatype.nexus.licensing.internal.ui.LicenseUserXO;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.apache.commons.fileupload.FileItem;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.hibernate.validator.constraints.NotEmpty;
import org.sonatype.licensing.LicensingException;
import org.sonatype.nexus.common.app.ApplicationLicense;
import org.sonatype.nexus.common.wonderland.AuthTicketService;
import org.sonatype.nexus.extdirect.DirectComponentSupport;
import org.sonatype.nexus.validation.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Named
@Singleton
@DirectAction(action={"licensing_Licensing"})
public class LicensingComponent
extends DirectComponentSupport
implements GroovyObject {
    @Inject
    private ApplicationLicense applicationLicense;
    @Inject
    private LicenseUtil licenseUtil;
    @Inject
    private AuthTicketService authTickets;
    @Inject
    private AccessLog accessLog;
    @Named(value="${nexus.license.service.url:-https://links.sonatype.com/products/nexus/licensing}")
    @Inject
    private String licenseServiceUrl;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    public LicensingComponent() {
        MetaClass metaClass;
        CallSite[] callSiteArray = LicensingComponent.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:licensing:read"})
    public LicenseDetailsXO read() {
        CallSite[] callSiteArray = LicensingComponent.$getCallSiteArray();
        Object license = null;
        try {
            Object object;
            license = object = callSiteArray[0].callGetProperty((Object)this.licenseUtil);
        }
        catch (LicensingException le) {
            LicenseDetailsXO licenseDetailsXO = (LicenseDetailsXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[1].callConstructor(LicenseDetailsXO.class), LicenseDetailsXO.class);
            return licenseDetailsXO;
        }
        return (LicenseDetailsXO)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(LicenseDetailsXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"contactCompany", callSiteArray[3].callGetProperty(license), "contactEmail", callSiteArray[4].callGetProperty(license), "contactName", callSiteArray[5].callGetProperty(license), "effectiveDate", callSiteArray[6].callGetProperty(license), "expirationDate", callSiteArray[7].callGetProperty(license), "licensedUsers", ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[8].callGetProperty(license), (Object)-1) ? "Unlimited" : callSiteArray[9].callGetProperty(license), "connections", callSiteArray[10].call(callSiteArray[11].callGetProperty((Object)this.accessLog)), "licenseType", callSiteArray[12].call(callSiteArray[13].call(callSiteArray[14].callGetProperty(license), (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _read_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _read_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "description";
                return new CallSiteArray(_read_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _read_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), (Object)"; "), "licenseServiceUrl", this.licenseServiceUrl, "fingerprint", callSiteArray[15].callGetProperty((Object)this.applicationLicense), "features", callSiteArray[16].call(callSiteArray[17].callGetProperty(license), (Object)", ")})), LicenseDetailsXO.class);
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresPermissions(value={"nexus:licensing:read"})
    public List<LicenseUserXO> readLicenseUsers() {
        CallSite[] callSiteArray = LicensingComponent.$getCallSiteArray();
        return (List)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].call(callSiteArray[19].call((Object)this.accessLog), (Object)new GeneratedClosure((Object)this, (Object)this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;
            {
                CallSite[] callSiteArray = _readLicenseUsers_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object input) {
                CallSite[] callSiteArray = _readLicenseUsers_closure2.$getCallSiteArray();
                return callSiteArray[0].callConstructor(LicenseUserXO.class, (Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"ip", callSiteArray[1].callGetProperty(input), "userId", callSiteArray[2].callGetProperty(input), "userAgent", callSiteArray[3].callGetProperty(input), "timestamp", callSiteArray[4].callGetProperty(input)}));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _readLicenseUsers_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "<$constructor$>";
                stringArray[1] = "ip";
                stringArray[2] = "userId";
                stringArray[3] = "userAgent";
                stringArray[4] = "timestamp";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[5];
                _readLicenseUsers_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_readLicenseUsers_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _readLicenseUsers_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }), List.class);
    }

    @DirectFormPostMethod
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:licensing:create"})
    @Validate
    public void install(@NotNull Map<String, String> params, @NotNull Map<String, FileItem> files) {
        CallSite[] callSiteArray = LicensingComponent.$getCallSiteArray();
        callSiteArray[20].callStatic(Preconditions.class, callSiteArray[21].call(params, (Object)"authToken"));
        FileItem item = (FileItem)ScriptBytecodeAdapter.castToType((Object)callSiteArray[22].call(files, (Object)"license"), FileItem.class);
        if (DefaultTypeTransformation.booleanUnbox((Object)item)) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[23].call((Object)this.authTickets, callSiteArray[24].call(params, (Object)"authToken")))) {
                throw (Throwable)callSiteArray[27].callConstructor(IllegalAccessException.class, (Object)"Invalid authentication ticket");
            }
        } else {
            throw (Throwable)callSiteArray[28].callConstructor(IllegalArgumentException.class, (Object)"License file not uploaded");
        }
        callSiteArray[25].call((Object)this.licenseUtil, callSiteArray[26].call((Object)item));
    }

    @DirectMethod
    @Timed
    @ExceptionMetered
    @RequiresAuthentication
    @RequiresPermissions(value={"nexus:licensing:delete"})
    @Validate
    public void uninstall(@NotEmpty String authToken) {
        CallSite[] callSiteArray = LicensingComponent.$getCallSiteArray();
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[29].call((Object)this.authTickets, (Object)authToken))) {
            throw (Throwable)callSiteArray[31].callConstructor(IllegalAccessException.class, (Object)"Invalid authentication ticket");
        }
        callSiteArray[30].call((Object)this.licenseUtil);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != LicensingComponent.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public ApplicationLicense getApplicationLicense() {
        return this.applicationLicense;
    }

    public void setApplicationLicense(ApplicationLicense applicationLicense) {
        this.applicationLicense = applicationLicense;
    }

    public LicenseUtil getLicenseUtil() {
        return this.licenseUtil;
    }

    public void setLicenseUtil(LicenseUtil licenseUtil) {
        this.licenseUtil = licenseUtil;
    }

    public AuthTicketService getAuthTickets() {
        return this.authTickets;
    }

    public void setAuthTickets(AuthTicketService authTicketService) {
        this.authTickets = authTicketService;
    }

    public AccessLog getAccessLog() {
        return this.accessLog;
    }

    public void setAccessLog(AccessLog accessLog) {
        this.accessLog = accessLog;
    }

    public String getLicenseServiceUrl() {
        return this.licenseServiceUrl;
    }

    public void setLicenseServiceUrl(String string) {
        this.licenseServiceUrl = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "licenseDetails";
        stringArray[1] = "<$constructor$>";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "contactCompany";
        stringArray[4] = "contactEmailAddress";
        stringArray[5] = "contactName";
        stringArray[6] = "effectiveDate";
        stringArray[7] = "expirationDate";
        stringArray[8] = "licensedUsers";
        stringArray[9] = "licensedUsers";
        stringArray[10] = "size";
        stringArray[11] = "uniqueIPAddresses";
        stringArray[12] = "join";
        stringArray[13] = "collect";
        stringArray[14] = "featureSet";
        stringArray[15] = "fingerprint";
        stringArray[16] = "join";
        stringArray[17] = "rawFeatures";
        stringArray[18] = "collect";
        stringArray[19] = "get";
        stringArray[20] = "checkNotNull";
        stringArray[21] = "getAt";
        stringArray[22] = "getAt";
        stringArray[23] = "redeemTicket";
        stringArray[24] = "getAt";
        stringArray[25] = "install";
        stringArray[26] = "get";
        stringArray[27] = "<$constructor$>";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "redeemTicket";
        stringArray[30] = "uninstallLicense";
        stringArray[31] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[32];
        LicensingComponent.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(LicensingComponent.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = LicensingComponent.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

