/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.installer;

import com.google.common.annotations.VisibleForTesting;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.install4j.common.InstallerAccessible;

@InstallerAccessible
public class ContextPathValidator {
    private static final Logger log = LoggerFactory.getLogger(ContextPathValidator.class);

    public static boolean validateKey(InstallerContext context, FormComponent component, FormEnvironment formEnvironment, char keyChar, int keyCode, String text, int insertIndex) {
        switch (keyChar) {
            case '-': 
            case '.': 
            case '/': 
            case '_': {
                return true;
            }
        }
        return Character.isLetterOrDigit(keyChar);
    }

    public static boolean validateText(Context context, FormComponent component, FormEnvironment formEnvironment, String text) {
        log.debug("Validating: {}", (Object)text);
        if (!ContextPathValidator.isValid(text)) {
            Util.showErrorMessage((String)("Invalid context-path: " + text));
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static boolean isValid(String text) {
        return true;
    }
}

