/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.installer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.net.HostSpecifier;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.install4j.common.InstallerAccessible;

@InstallerAccessible
public class HostValidator {
    private static final Logger log = LoggerFactory.getLogger(HostValidator.class);

    public static boolean validateKey(InstallerContext context, FormComponent component, FormEnvironment formEnvironment, char keyChar, int keyCode, String text, int insertIndex) {
        switch (keyChar) {
            case '-': 
            case '.': {
                return true;
            }
        }
        return Character.isLetterOrDigit(keyChar);
    }

    public static boolean validateText(Context context, FormComponent component, FormEnvironment formEnvironment, String text) {
        log.debug("Validating: {}", (Object)text);
        if (HostValidator.isValid(text)) {
            return true;
        }
        Util.showErrorMessage((String)("Invalid host: " + text));
        return false;
    }

    @VisibleForTesting
    static boolean isValid(String text) {
        return "localhost".equals(text) || HostSpecifier.isValid((String)text);
    }
}

