/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.installer;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.InstallerScreen;
import com.sonatype.nexus.installer.PortAvailability;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.install4j.common.InstallerAccessible;
import org.sonatype.install4j.common.Variables;

@InstallerAccessible
public class InstallerHelper {
    private static final Logger log = LoggerFactory.getLogger(InstallerHelper.class);
    public static final String USER_HOME = "user.home";
    public static final String SYS_SHORT_NAME = "sys.shortName";
    public static final String SYS_LOCAL_APPDATA_DIR = "sys.localAppdataDir";
    public static final String NEXUS_HTTP_HOST = "nexus.httpHost";
    public static final String NEXUS_HTTP_PORT = "nexus.httpPort";
    public static final String NEXUS_HTTP_CONTEXT_PATH = "nexus.httpContextPath";
    public static final String NEXUS_DATA_DIR = "nexus.dataDir";

    private InstallerHelper() {
    }

    public static void detectDataDir(Context context) {
        File dir;
        File userHome = new File(System.getProperty(USER_HOME));
        String shortName = context.getCompilerVariable(SYS_SHORT_NAME);
        if (Util.isWindows()) {
            File tmp = Variables.getFileVariable((Context)context, (String)SYS_LOCAL_APPDATA_DIR);
            dir = new File(tmp, shortName);
        } else if (Util.isMacOS()) {
            File tmp = new File(userHome, "Library/Application Support");
            dir = new File(tmp, shortName);
        } else {
            dir = Util.hasFullAdminRights() ? new File("/var/nexus") : new File(userHome, "." + shortName);
        }
        log.debug("Detected default {}: {}", (Object)NEXUS_DATA_DIR, (Object)dir);
        context.setVariable(NEXUS_DATA_DIR, (Object)dir.getAbsolutePath());
    }

    public static URL calculateUrl(Context context) throws MalformedURLException {
        String host = Variables.getStringVariable((Context)context, (String)NEXUS_HTTP_HOST);
        if ("0.0.0.0".equals(host)) {
            host = "localhost";
        }
        String port = Variables.getStringVariable((Context)context, (String)NEXUS_HTTP_PORT);
        String contextPath = Variables.getStringVariable((Context)context, (String)NEXUS_HTTP_CONTEXT_PATH);
        return new URL(String.format("http://%s:%s%s", host, port, contextPath));
    }

    public static boolean validateOptionsScreen(InstallerContext context, InstallerScreen screen, FormEnvironment formEnvironment) {
        return InstallerHelper.validatePortAvailable((Context)context, NEXUS_HTTP_PORT);
    }

    private static boolean validatePortAvailable(Context context, String variable) {
        int port = Variables.getIntegerVariable((Context)context, (String)variable);
        log.debug("Checking port: {}", (Object)port);
        PortAvailability.Result result = new PortAvailability().isAvailable(port);
        if (!result.available) {
            if (result.error == null) {
                Util.showErrorMessage((String)("Port is in use: " + port + "\nPlease select another port."));
            } else {
                Util.log((Throwable)result.error);
                Util.showErrorMessage((String)("Port appears to be unavailable:\n" + result.error + "\nPlease select another port."));
            }
        }
        return result.available;
    }
}

