/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.installer;

import com.install4j.api.JVMSelector;
import com.install4j.api.Util;
import com.install4j.api.actions.InstallAction;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.formcomponents.FormEnvironment;
import com.install4j.api.screens.InstallerScreen;
import com.sonatype.nexus.installer.JvmLocationDisplay;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.install4j.common.InstallerAccessible;

@InstallerAccessible
public class JvmHelper {
    private static final Logger log = LoggerFactory.getLogger(JvmHelper.class);
    public static final String SYS_JAVA_MIN_VERSION = "sys.javaMinVersion";
    public static final String SYS_JAVA_MAX_VERSION = "sys.javaMaxVersion";
    public static final String JVM_HOME = "jvm.home";
    public static final String JVM_SELECTION_MODE = "jvm.selectionMode";
    public static final String BUNDLED_MODE = "bundled";
    public static final String JVM_BUNDLED = "jvm.bundled";
    public static final String EXISTING_MODE = "existing";
    public static final String JVM_LOCATIONS = "jvm.locations";
    public static final String JVM_LOCATIONS_COUNT = "jvm.locationsCount";
    public static final String JVM_EXISTING_INDEX = "jvm.existingIndex";
    public static final String JVM_EXISTING_DIR = "jvm.existingDir";
    public static final String ALTERNATIVE_MODE = "alternative";
    public static final String JVM_ALTERNATIVE_DIR = "jvm.alternativeDir";

    private JvmHelper() {
    }

    public static boolean isJreBundled(InstallerContext context) {
        return "true".equals(context.getCompilerVariable(JVM_BUNDLED));
    }

    public static boolean detect(InstallerContext context, InstallAction action) throws Exception {
        String javaMinVersion = context.getCompilerVariable(SYS_JAVA_MIN_VERSION);
        String javaMaxVersion = context.getCompilerVariable(SYS_JAVA_MAX_VERSION);
        log.debug("Detecting JVM installations; min={} max={}", (Object)javaMinVersion, (Object)javaMaxVersion);
        JVMSelector.JVMLocation[] locations = JVMSelector.getJVMLocations((String)javaMinVersion, (String)javaMaxVersion, (boolean)false, null);
        context.setVariable(JVM_LOCATIONS, (Object)JvmLocationDisplay.wrap(locations));
        context.setVariable(JVM_LOCATIONS_COUNT, (Object)locations.length);
        if (Util.isWindows() && !context.isConsole()) {
            Thread.sleep(1500L);
        }
        return true;
    }

    public static void prepareScreen(InstallerContext context, InstallerScreen screen, FormEnvironment formEnvironment) throws Exception {
        JVMSelector.JVMLocation[] locations;
        if (context.getVariable(JVM_SELECTION_MODE) == null && ((locations = (JVMSelector.JVMLocation[])context.getVariable(JVM_LOCATIONS)) == null || locations.length == 0)) {
            if (JvmHelper.isJreBundled(context)) {
                log.debug("No existing JVM locations detected, defaulting to bundled mode");
                context.setVariable(JVM_SELECTION_MODE, (Object)BUNDLED_MODE);
            } else {
                log.debug("No existing JVM locations detected, defaulting to alternative mode");
                context.setVariable(JVM_SELECTION_MODE, (Object)ALTERNATIVE_MODE);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean select(InstallerContext context, InstallerScreen screen, FormEnvironment formEnvironment) throws Exception {
        String jvmHome;
        block9: {
            String mode = (String)context.getVariable(JVM_SELECTION_MODE);
            log.debug("Selection mode: {}", (Object)mode);
            jvmHome = null;
            if (ALTERNATIVE_MODE.equals(mode)) {
                String javaMaxVersion;
                String alternativeDir = (String)context.getVariable(JVM_ALTERNATIVE_DIR);
                if (alternativeDir.trim().length() == 0) {
                    Util.showErrorMessage((String)"Please select an alternative JVM location.");
                    return false;
                }
                File dir = new File(alternativeDir);
                String javaMinVersion = context.getCompilerVariable(SYS_JAVA_MIN_VERSION);
                if (JVMSelector.getJVMLocation((File)dir, (String)javaMinVersion, (String)(javaMaxVersion = context.getCompilerVariable(SYS_JAVA_MAX_VERSION)), (boolean)true) != null) {
                    jvmHome = dir.getAbsolutePath();
                    break block9;
                } else {
                    String message = "The selected location does not contain a suitable JVM:\n" + dir;
                    if (context.isUnattended()) {
                        Util.logInfo(null, (String)message);
                        return false;
                    }
                    Util.showErrorMessage((String)message);
                    return false;
                }
            }
            if (EXISTING_MODE.equals(mode)) {
                JVMSelector.JVMLocation[] locations = (JVMSelector.JVMLocation[])context.getVariable(JVM_LOCATIONS);
                Integer index = (Integer)context.getVariable(JVM_EXISTING_INDEX);
                if (index != null && locations != null && index >= 0 && index < locations.length) {
                    jvmHome = locations[index].getJavaHome().getAbsolutePath();
                    context.setVariable(JVM_EXISTING_DIR, (Object)jvmHome);
                } else {
                    Util.showErrorMessage((String)"Please select an existing JVM location.");
                    return false;
                }
            }
        }
        if (jvmHome != null) {
            JVMSelector.setPreferredJVM(jvmHome);
            context.setVariable(JVM_HOME, jvmHome);
            context.registerResponseFileVariable(JVM_HOME);
            log.info("Using JVM: {}", jvmHome);
            return true;
        }
        log.info("Using bundled JVM");
        return true;
    }
}

