/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.installer;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortAvailability {
    private static final Logger log = LoggerFactory.getLogger(PortAvailability.class);

    public Result isAvailable(int port) {
        log.debug("Validating port: {}", (Object)port);
        ServerSocket serverSocket = null;
        try {
            try {
                log.debug("Attempting server-socket establish: {}", (Object)port);
                serverSocket = new ServerSocket(port);
                serverSocket.setReuseAddress(true);
            }
            catch (Exception e) {
                Result result = new Result(false, e);
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e2) {
                        log.debug("Socket close failed; ignoring", (Throwable)e2);
                    }
                }
                return result;
            }
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    log.debug("Socket close failed; ignoring", (Throwable)e);
                }
            }
        }
        Socket socket = null;
        try {
            log.debug("Attempting client-socket connection: {}", (Object)port);
            socket = new Socket("localhost", port);
            socket.setReuseAddress(true);
            Result result = new Result(false, null);
            return result;
        }
        catch (Exception exception) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    log.debug("Socket close failed; ignoring", (Throwable)e);
                }
            }
        }
        return new Result(true, null);
    }

    public static class Result {
        public final boolean available;
        public final Throwable error;

        public Result(boolean available, Throwable error) {
            this.available = available;
            this.error = error;
        }
    }
}

