/*
 * Decompiled with CFR 0.152.
 */
package com.sonatype.nexus.installer;

import com.google.common.annotations.VisibleForTesting;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.formcomponents.FormComponent;
import com.install4j.api.formcomponents.FormEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.install4j.common.InstallerAccessible;

@InstallerAccessible
public class PortValidator {
    private static final Logger log = LoggerFactory.getLogger(PortValidator.class);

    public static boolean validateKey(InstallerContext context, FormComponent component, FormEnvironment formEnvironment, char keyChar, int keyCode, String text, int insertIndex) {
        return Character.isDigit(keyChar);
    }

    public static boolean validateText(Context context, FormComponent component, FormEnvironment formEnvironment, String text) {
        log.debug("Validating: {}", (Object)text);
        if (PortValidator.isValid(text)) {
            return true;
        }
        Util.showErrorMessage((String)("Invalid port: " + text));
        return false;
    }

    @VisibleForTesting
    static boolean isValid(String text) {
        try {
            int value = Integer.parseInt(text);
            return value >= 0 && value <= 65535;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

