/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.httpbridge.HttpResponseSender;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.Status;

@Named
@Singleton
public class DefaultHttpResponseSender
extends ComponentSupport
implements HttpResponseSender {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(@Nullable Request request, Response response, HttpServletResponse httpResponse) throws ServletException, IOException {
        this.log.debug("Sending response: {}", (Object)response);
        for (Map.Entry header : response.getHeaders()) {
            httpResponse.addHeader((String)header.getKey(), (String)header.getValue());
        }
        Status status = response.getStatus();
        String statusMessage = status.getMessage();
        Throwable throwable = null;
        Object var7_8 = null;
        try (Payload payload = response.getPayload();){
            if (status.isSuccessful() || payload != null) {
                if (statusMessage == null) {
                    httpResponse.setStatus(status.getCode());
                } else {
                    httpResponse.setStatus(status.getCode(), statusMessage);
                }
                if (payload == null) return;
                this.log.trace("Attaching payload: {}", (Object)payload);
                if (payload.getContentType() != null) {
                    httpResponse.setContentType(payload.getContentType());
                }
                if (payload.getSize() != -1L) {
                    httpResponse.setContentLengthLong(payload.getSize());
                }
                if (request == null || "HEAD".equals(request.getAction())) return;
                Throwable throwable2 = null;
                Object var10_13 = null;
                try {
                    InputStream input = payload.openInputStream();
                    try {
                        try (ServletOutputStream output = httpResponse.getOutputStream();){
                            ByteStreams.copy((InputStream)input, (OutputStream)output);
                        }
                        if (input == null) return;
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        if (input == null) throw throwable2;
                        input.close();
                        throw throwable2;
                    }
                    input.close();
                    return;
                }
                catch (Throwable throwable4) {
                    if (throwable2 == null) {
                        throwable2 = throwable4;
                        throw throwable2;
                    } else {
                        if (throwable2 == throwable4) throw throwable2;
                        throwable2.addSuppressed(throwable4);
                    }
                    throw throwable2;
                }
            }
            httpResponse.sendError(status.getCode(), statusMessage);
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            } else {
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
            }
            throw throwable;
        }
    }
}

