/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sonatype.goodies.common.ComponentSupport;

@Named
@Singleton
public class ExhaustRequestFilter
extends ComponentSupport
implements Filter {
    private final Pattern exhaustForAgentsPattern;

    @Inject
    public ExhaustRequestFilter(@Named(value="${nexus.view.exhaustForAgents:-Apache-Maven.*|Apache Ivy.*}") String exhaustForAgents) {
        this.exhaustForAgentsPattern = Pattern.compile(exhaustForAgents.replace("\\s,\\s", "|"));
        if (this.log.isDebugEnabled()) {
            this.log.debug("nexus.view.exhaustForAgents={}", (Object)this.exhaustForAgentsPattern.pattern());
        }
    }

    public void init(FilterConfig filterConfig) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (this.exhaustRequest(request, response)) {
                try {
                    Throwable e = null;
                    Object var6_13 = null;
                    try (ServletInputStream in = request.getInputStream();){
                        ByteStreams.exhaust((InputStream)in);
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (Exception e) {
                    this.log.debug("Unable to exhaust request", (Throwable)e);
                }
            }
        }
    }

    public void destroy() {
    }

    private boolean exhaustRequest(ServletRequest request, ServletResponse response) {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            String method;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            if (this.log.isTraceEnabled()) {
                String agent = httpRequest.getHeader("User-Agent");
                this.log.trace("status: {}, method: {}, agent: {}, match: {}", new Object[]{httpResponse.getStatus(), httpRequest.getMethod(), agent, agent != null && this.exhaustForAgentsPattern.matcher(agent).matches()});
            }
            if (httpResponse.getStatus() >= 400 && ("PUT".equals(method = httpRequest.getMethod()) || "POST".equals(method))) {
                String agent = httpRequest.getHeader("User-Agent");
                return agent != null && this.exhaustForAgentsPattern.matcher(agent).matches();
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("req: {}, resp: {}", request.getClass(), response.getClass());
        }
        return false;
    }
}

