/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import javax.inject.Named;
import org.sonatype.nexus.repository.httpbridge.internal.ExhaustRequestFilter;
import org.sonatype.nexus.repository.httpbridge.internal.ViewServlet;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.SecurityFilter;

@Named
public class HttpBridgeModule
extends AbstractModule {
    public static final String MOUNT_POINT = "/repository";

    protected void configure() {
        this.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.bind(ViewServlet.class);
                this.serve("/repository/*", new String[0]).with(ViewServlet.class);
                this.bindViewFiltersFor("/repository/*", new String[0]);
            }

            private void bindViewFiltersFor(String urlPattern, String ... morePatterns) {
                this.bindViewFilters(this.filter(urlPattern, morePatterns));
            }

            private void bindViewFilters(ServletModule.FilterKeyBindingBuilder filter) {
                filter.through(ExhaustRequestFilter.class);
                filter.through(SecurityFilter.class);
            }
        });
        this.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/repository/**", new String[]{"nx-authc", "nx-apikey-authc", "nx-anonymous", "nx-anticsrf-authc"});
            }
        });
    }
}

