/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.httpbridge.HttpResponseSender;
import org.sonatype.nexus.repository.httpbridge.internal.DefaultHttpResponseSender;

@Singleton
@Named
class HttpResponseSenderSelector
extends ComponentSupport {
    private final Map<String, HttpResponseSender> responseSenders;
    private final DefaultHttpResponseSender defaultHttpResponseSender;

    @Inject
    public HttpResponseSenderSelector(Map<String, HttpResponseSender> responseSenders, DefaultHttpResponseSender defaultHttpResponseSender) {
        this.responseSenders = (Map)Preconditions.checkNotNull(responseSenders);
        this.defaultHttpResponseSender = (DefaultHttpResponseSender)Preconditions.checkNotNull((Object)defaultHttpResponseSender);
    }

    @Nonnull
    public HttpResponseSender defaultSender() {
        return this.defaultHttpResponseSender;
    }

    @Nonnull
    public HttpResponseSender sender(Repository repository) {
        String format = repository.getFormat().getValue();
        this.log.debug("Looking for HTTP response sender: {}", (Object)format);
        HttpResponseSender sender = this.responseSenders.get(format);
        if (sender == null) {
            return this.defaultHttpResponseSender;
        }
        return sender;
    }
}

