/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.httpbridge.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.servlet.ServletModule;
import org.apache.shiro.web.filter.mgt.FilterChainResolver;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.eclipse.sisu.inject.Sources;
import org.sonatype.nexus.repository.httpbridge.internal.ExhaustRequestFilter;
import org.sonatype.nexus.repository.httpbridge.internal.LegacyViewServlet;
import org.sonatype.nexus.security.FilterChainModule;
import org.sonatype.nexus.security.SecurityFilter;

public class LegacyHttpBridgeModule
extends AbstractModule {
    protected void configure() {
        this.bind(LegacyViewServlet.class);
        this.bind(ExhaustRequestFilter.class);
        this.requireBinding(WebSecurityManager.class);
        this.requireBinding(FilterChainResolver.class);
        Binder highPriorityBinder = this.binder().withSource((Object)Sources.prioritize((int)0x50000000));
        highPriorityBinder.install((Module)new ServletModule(){

            protected void configureServlets() {
                this.serve("/content/groups/*", new String[]{"/content/repositories/*", "/content/sites/*"}).with(LegacyViewServlet.class);
                this.bindViewFiltersFor("/content/groups/*", "/content/repositories/*", "/content/sites/*");
                this.serveRegex("/service/local/.*?(/.*)", new String[0]).with(LegacyViewServlet.class);
                this.bindViewFiltersRegexFor("/service/local/.*?(/.*)", new String[0]);
            }

            private void bindViewFiltersFor(String urlPattern, String ... morePatterns) {
                this.bindViewFilters(this.filter(urlPattern, morePatterns));
            }

            private void bindViewFiltersRegexFor(String urlPattern, String ... morePatterns) {
                this.bindViewFilters(this.filterRegex(urlPattern, morePatterns));
            }

            private void bindViewFilters(ServletModule.FilterKeyBindingBuilder filter) {
                filter.through(ExhaustRequestFilter.class);
                filter.through(SecurityFilter.class);
            }
        });
        highPriorityBinder.install((Module)new FilterChainModule(){

            protected void configure() {
                this.addFilterChain("/content/**", new String[]{"nx-authc", "nx-apikey-authc", "nx-anonymous", "nx-anticsrf-authc"});
                this.addFilterChain("/service/local/**", new String[]{"nx-authc", "nx-apikey-authc", "nx-anonymous", "nx-anticsrf-authc"});
            }
        });
    }
}

